﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Performance.DtoModels;

namespace Performance.Api.Controllers
{
    public class AppController : Controller
    {
        private readonly ILogger<AppController> _logger;
        private readonly IConfiguration _configuration;

        public AppController(ILogger<AppController> logger, IConfiguration configuration)
        {
            _logger = logger;
            _configuration = configuration;
        }

        [AllowAnonymous, HttpGet, Route("api/app/options")]
        public ActionResult AppOptions()
        {
            var OpenOAuth = _configuration.GetValue<bool>("AppOptions:OpenOAuth", false);
            var siteTitle = _configuration.GetValue("AppOptions:SiteTitle", "");
            var siteLogo = _configuration.GetValue("AppOptions:SiteLogo", "");
            return Ok(new ApiResponse(ResponseType.OK, "", new { OpenOAuth, siteTitle, siteLogo }));
        }
    }
}