﻿using System.ComponentModel;

namespace Performance.DtoModels
{
    /// <summary> 验证码类型 </summary>
    public enum SmsCodeType
    {
        [Description("登录")]
        Login = 1,
        [Description("其他")]
        Other = 2,
    }

    /// <summary> 用户状态 </summary>
    public enum States
    {
        [Description("启用")]
        Enabled = 1,
        [Description("禁用")]
        Disabled = 2,
    }

    /// <summary> 提取数据使用模板 </summary>
    public enum UseTemplate
    {
        /// <summary> 上次绩效 </summary>
        [Description("上次绩效")]
        LastAllot = 1,
        /// <summary> 配置模板 </summary>
        [Description("配置模板")]
        Config = 2,
    }

    /// <summary> 提取数据使用模板 </summary>
    public enum DbSrouceType
    {
        /// <summary> 标准库 </summary>
        [Description("标准库")]
        Standard = 1,
        /// <summary> 绩效库 </summary>
        [Description("绩效库")]
        Performance = 2,
    }


    public enum AgWorkloadType
    {
        /// <summary>
        /// 核算前奖励
        /// </summary>
        PreAccountingReward = -2,
        /// <summary>
        /// 单项奖励
        /// </summary>
        SingleAwards = -1,
        /// <summary>
        /// 工作量
        /// </summary>
        Workload = 0,
    }

    /// <summary>
    /// 工作量金额计算规则
    /// </summary>
    public enum AgWorkPurpose
    {
        工作量系数 = 0,
        工作量固定金额 = 1,
    }

    public enum DataFormat
    {
        /// <summary> 普通格式 </summary>
        普通格式,
        /// <summary> 小数 </summary>
        小数,
        /// <summary> 小数1位 </summary>
        小数1,
        /// <summary> 小数2位 </summary>
        小数2,
        /// <summary> 整数 </summary>
        整数,
        /// <summary> 货币 </summary>
        货币,
        /// <summary> 百分比 </summary>
        百分比,
        /// <summary> 科学计数 </summary>
        科学计数,
        /// <summary> 分数 </summary>
        分数,
        /// <summary> 日期 </summary>
        日期YYYYMMDD
    }

    public class Background
    {
        public enum JobType
        {
            生成测算表 = 1,
            提取数据 = 2,
            报表 = 3,
            自定义抽取 = 4,
            每日汇报表汇总 = 5,
        }
        public enum Status
        {
            等待 = 1,
            执行中 = 2,
            完成 = 3,
            失败 = 10,
            无效 = 88,
            超时 = 99,
        }
    }

    public class Attendance
    {
        public enum Type
        {
            开始,
            调入,
            结束,
        }
        public enum Deduction
        {
            不核减 = 0,
            核减 = 1,
        }
        public enum Default
        {
            非默认 = 0,
            默认 = 1,
        }
        public enum State
        {
            全部 = 0,
            未确认 = 1,
            确认 = 2,
            驳回 = 3,
        }
        /// <summary>
        /// 考勤上报
        /// </summary>
        public enum Report
        {
            未提交 = 1,
            提交 = 2,
            通过 = 3,
            驳回 = 4,
        }
        public enum OperationType
        {
            全部 = 0,
            新增 = 1,
            修改 = 2,
            删除 = 3,
        }
    }
    public class Assess
    {
        public enum SchemeItemsTarget
        {
            全部 = 0,
            已设置其他方案 = 1,
            未设置方案 = 2,
            已设置方案 = 4,
        }
        public enum AssessState
        {
            未提交 = 1,
            待审核 = 2,
            审核通过 = 3,
            驳回 = 4,
        }
    }



    public class SecondAllot
    {
        public enum Status
        {
            未提交 = 1,
            等待审核 = 2,
            审核通过 = 3,
            驳回 = 4,
        }
    }

    public class EnumResult
    {
        public enum AuditGather
        {
            未审核 = 0,
            未通过 = 1,
            已通过 = 2,
        }
        public enum FromSource
        {
            提取 = 0,
            录入 = 1,
        }
    }

    public class UniteDept
    {
        public enum Title
        {
            业绩分值 = 2100,
            在册人数 = 2101,
            DRG绩效 = 2102,
            预算比例 = 2110,
            业绩绩效 = 2120,
            工作量绩效 = 2130,
            考核前其他绩效 = 2140,
            考核前绩效 = 2150,
            考核得分率 = 2160,
            药占比奖罚 = 2170,
            材料占比奖罚 = 2180,
            医院奖罚 = 2190,
            考核后绩效 = 2200,
            考核后其他绩效 = 2210,
            调节系数 = 2220,
            调节后其他绩效 = 2230,
            实发绩效 = 2240,
        }
        public enum DisplayRule
        {
            始终隐藏,
            始终显示,
            下发显示,
            总额下发后显示,
        }
        public enum Format
        {
            无,
            整数,
            一位小数,
            两位小数,
            三位小数,
            四位小数,
            整数百分比,
            一位小数百分比,
            两位小数百分比,
            三位小数百分比,
            四位小数百分比,
        }
    }

    public class ManagementDept
    {
        public enum TitleManage
        {
            考核前其他绩效 = 3001,
            考核前绩效 = 3101,
            核算人数 = 3200,
            人均绩效 = 3300,
            基础绩效系数 = 3400,
            出勤率 = 3501,
            实际人均 = 3600,
            效率绩效人数 = 3700,
            效率系数 = 3800,
            效率绩效小计 = 3900,
            规模绩效系数 = 4000,
            规模绩效小计 = 4100,
            管理绩效发放系数 = 4200,
            其他管理绩效 = 4220,
            考核前管理绩效 = 4300,
            考核得分率 = 4401,
            考核后管理绩效 = 4500,
            医院奖罚 = 4601,
            夜班费 = 4611,
            考核后绩效 = 4621,
            调节系数 = 4801,
            调节后其他绩效 = 4901,
            调节后其他管理绩效 = 4910,
            绩效合计 = 5001,
        }
        public enum DisplayRule
        {
            始终隐藏,
            始终显示,
            下发显示,
            总额下发后显示,
        }
        public enum Format
        {
            无,
            整数,
            一位小数,
            两位小数,
            三位小数,
            四位小数,
            整数百分比,
            一位小数百分比,
            两位小数百分比,
            三位小数百分比,
            四位小数百分比,
        }
        public enum CustomTableLimitation
        {
            通过核算单元或者核算组别进行限制 = 0,
            无限制 = 1,

        }
    }
}
