﻿using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class PerSheet
    {
        /// <summary>
        /// sheet名称
        /// </summary>
        public string SheetName { get; set; }
        /// <summary>
        /// sheet模板类型
        /// </summary>
        public SheetType SheetType { get; set; }
        /// <summary>
        /// sheet模块名称
        /// </summary>
        public string ModuleName { get; set; }
        /// <summary>
        /// sheet头部
        /// </summary>
        public List<PerHeader> PerHeader { get; set; }
        /// <summary>
        /// sheet数据
        /// </summary>
        public List<IPerData> PerData { get; set; }

        public PerSheet() { }

        public PerSheet(string sheetName, string moduleName, SheetType sheetType, List<PerHeader> perHeader, List<IPerData> perData)
        {
            SheetName = sheetName;
            ModuleName = moduleName;
            SheetType = sheetType;
            PerHeader = perHeader;
            PerData = perData;
        }
    }
}
