﻿using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class StatisticsInfoDto
    {
        public int StatisticsID { get; set; }
        public int HospitalId { get; set; }
        /// <summary>
        /// 每月汇总表名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 报表对比 0 不允许对比 1 允许对比
        /// </summary>
        public int IsComparison { get; set; }
        public List<StatisticsSelectionDto> Selections { get; set; }
    }

    public class StatisticsSelectionDto
    {
        public int SelectionID { get; set; }

        public int? StatisticsID { get; set; }

        /// <summary>
        /// 条件标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public decimal? Sort { get; set; }

        /// <summary>
        /// 控件名称
        /// </summary>
        public string InputName { get; set; }

        /// <summary>
        /// 控件类型（1：input框、2：radio单选、3：checkbox多选、4：select单选、5：select多选、6：自动补全单选、7：自动补全多选、10：日期区间）
        /// </summary>
        public string InputType { get; set; }

        /// <summary>
        /// 是否必填(1表示必填0表示非必填）
        /// </summary>
        public int? Required { get; set; }

        /// <summary>
        /// 数据集合
        /// </summary>
        public List<TitleValue> Options { get; set; }
    }




    public class StatisticsQuery
    {
        public int HospitalID { get; set; }
        public int StatisticsID { get; set; }
        /// <summary>
        /// 结果返回用途 首次查询 0 用于比对 1 用于对比
        /// </summary>
        public int? IsComparison { get; set; }
        public List<SelectionValues> Values { get; set; }
    }

    public class StatisticsQueryResultDto
    {
        /// <summary>
        /// 结果返回用途 首次查询 0 用于比对 1 用于对比
        /// </summary>
        public int? IsComparison { get; set; }
        public List<StatisticsColumn> Columns { get; set; }
        public List<Dictionary<string, object>> Datas { get; set; }

    }
    public class StatisticsColumn
    {
        public StatisticsColumn()
        {
            ColumnName = "";
            OrgColumnName = "";
            Fixed = "";
            ChildColumns = new List<StatisticsColumn>();
        }
        /// <summary>
        /// 显示名
        /// </summary>
        public string ColumnName { get; set; }
        /// <summary>
        /// 原始名，对应到数据列
        /// </summary>
        public string OrgColumnName { get; set; }
        /// <summary>
        /// 固定
        /// </summary>
        public string Fixed { get; set; }
        public List<StatisticsColumn> ChildColumns { get; set; }
    }
}
