﻿using System;

namespace Performance.DtoModels
{
    public class DeptResponse
    {
        /// <summary>
        ///
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Nullable<int> AllotID { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Nullable<int> SheetID { get; set; }
        /// <summary>
        /// 组别编码
        /// </summary>
        public string Code { get; set; }
        public int UnitType { get; set; }

        /// <summary>
        /// 分组名称（医生、护士）
        /// </summary>
        public string UnitName { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 科主任/护士长数量
        /// </summary>
        public Nullable<decimal> ManagerNumber { get; set; }

        /// <summary>
        /// 核算单元医生数量
        /// </summary>
        public Nullable<decimal> Number { get; set; }

        /// <summary>
        /// 医生基础系数
        /// </summary>
        public Nullable<decimal> BasicFactor { get; set; }

        /// <summary>
        /// 倾斜系数
        /// </summary>
        public Nullable<decimal> SlopeFactor { get; set; }

        /// <summary>
        /// 保底绩效参考标准
        /// </summary>
        public string MinimumReference { get; set; }

        /// <summary>
        /// 保底绩效系数
        /// </summary>
        public Nullable<decimal> MinimumFactor { get; set; }

        /// <summary>
        /// 保底绩效金额
        /// </summary>
        public Nullable<decimal> MinimumFee { get; set; }

        /// <summary>
        /// 其他绩效1
        /// </summary>
        public Nullable<decimal> OtherPerfor1 { get; set; }

        /// <summary>
        /// 其他绩效2
        /// </summary>
        public Nullable<decimal> OtherPerfor2 { get; set; }

        /// <summary>
        /// 药占比奖罚
        /// </summary>
        public Nullable<decimal> MedicineExtra { get; set; }

        /// <summary>
        /// 材料占比奖罚
        /// </summary>
        public Nullable<decimal> MaterialsExtra { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Extra { get; set; }

        /// <summary>
        /// 考核对分率
        /// </summary>
        public Nullable<decimal> ScoringAverage { get; set; }

        /// <summary>
        /// 考核后绩效
        /// </summary>
        public Nullable<decimal> ScoringPerfor { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> AdjustFactor { get; set; }

        /// <summary>
        /// 科室业绩
        /// </summary>
        public Nullable<decimal> Income { get; set; }

        /// <summary>
        /// 业绩绩效
        /// </summary>
        public Nullable<decimal> PerforFee { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> WorkloadFee { get; set; }

        /// <summary>
        /// 考核前绩效合计
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }

        /// <summary>
        /// 人均绩效
        /// </summary>
        public Nullable<decimal> Avg { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }

        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }

        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 考核后绩效
        /// </summary>
        public Nullable<decimal> AssessLaterPerforTotal { get; set; }

        /// <summary>
        /// 考核后管理绩效
        /// </summary>
        public Nullable<decimal> AssessLaterManagementFee { get; set; }

        /// <summary>
        /// 医院其他绩效
        /// </summary>
        public Nullable<decimal> AprPerforAmount { get; set; }
        /// <summary>
        /// 不公示其他绩效
        /// </summary>
        public Nullable<decimal> HideAprOtherPerforAmount { get; set; }
    }
}
