﻿using System;


public static partial class UtilExtensions
{
    public static string RemoveLineBreak(this string text)
    {
        return text.Replace("\n", "");
    }

    public static string RemoveEnter(this string text)
    {
        return text.Replace("\r", "");
    }
    public static string RemoveSpace(this string text)
    {
        return text.Replace(" ", "");
    }

    public static string Clean(this string text)
    {
        return text.Trim().RemoveEnter().RemoveLineBreak().RemoveSpace();
    }

    /// <summary>
    /// 分隔 移除空项
    /// </summary>
    /// <param name="text"></param>
    /// <param name="separator"></param>
    /// <returns></returns>
    public static string[] SplitRemoveEmpty(this string text, params string[] separator)
    {
        return text.Split(separator, StringSplitOptions.RemoveEmptyEntries);
    }

    /// <summary>
    /// 确定此字符串实例的开头是否与指定的匹配 忽略字母的大小写
    /// </summary>
    /// <param name="text"></param>
    /// <param name="value"></param>
    /// <returns></returns>
    public static bool StartsWithIgnoreCase(this string text, string value)
    {
        return text.StartsWith(value, StringComparison.OrdinalIgnoreCase);
    }

    /// <summary>
    /// 确定此字符串是否与指定的字符串对象具有相同的值 忽略字母的大小写
    /// </summary>
    /// <param name="text"></param>
    /// <param name="value"></param>
    /// <returns></returns>
    public static bool EqualsIgnoreCase(this string text, string value)
    {
        return text.Equals(value, StringComparison.OrdinalIgnoreCase);
    }
}
