﻿using System;
using System.Collections.Generic;
using System.Linq;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;

namespace Performance.Services
{
    /// <summary>
    /// 收入
    /// </summary>
    public class PerSheetDataReadIncome : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 4,
            HeaderLastRowNum = 4,
            HeaderFirstCellNum = 3,
            DataFirstRowNum = 5,
            DataFirstCellNum = 7,
            AccountingUnit = new List<AccountingUnit>
            {
                //核算单元（医技组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 3,
                    UnitType = "医技组",
                    DeptCellNum = 6,
                    FactorRow = 3,
                },
                //核算单元（医生组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 4,
                    UnitType = "医生组",
                    DeptCellNum = 6,
                    FactorRow = 2,
                },
                //核算单元（护理组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 5,
                    UnitType = "护理组",
                    DeptCellNum = 6,
                    FactorRow = 1,
                }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            //循环 当前有几个核算单元
            foreach (var unit in Point.AccountingUnit)
            {
                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);
                for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    if (row == null) continue;

                    for (int c = 0; c < vhead.Count(); c++)
                    {
                        var athead = vhead.ElementAt(c);
                        //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                        var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                        if (!cellValue.HasValue || cellValue.Value == 0)
                            continue;
                        var factorValue = sheet.GetRow(unit.FactorRow.Value)?.GetCell(athead.PointCell)?.GetValue();
                        PerData data = new PerData
                        {
                            RowNumber = r,
                            SignID = athead.SignID,
                            AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                            Department = row.GetCell(unit.DeptCellNum.Value).GetValue(),
                            TypeName = athead?.CellValue,
                            CellValue = cellValue,
                            //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                            UnitType = unit.UnitType, //手动匹配
                            //FactorValue = ConvertHelper.ToDecimalOrNull(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell)?.NumericCellValue),
                            FactorValue = !string.IsNullOrEmpty(factorValue) ? ConvertHelper.ToDecimalOrNull(factorValue) : null,
                            IsFactor = true,
                        };
                        if (string.IsNullOrEmpty(data.AccountingUnit) && string.IsNullOrEmpty(data.Department))
                            continue;
                        dataList.Add(data);
                    }
                }
            }
            return dataList;
        }
    }
}
