﻿//-----------------------------------------------------------------------
// <copyright file=" per_dept_dic.cs">
// * FileName: per_dept_dic.cs
// </copyright>
//-----------------------------------------------------------------------
using Performance.EntityModels;
using System.Collections.Generic;

namespace Performance.Repository
{
    /// <summary>
    /// per_dept_dic Repository
    /// </summary>
    public partial class PerforPerdeptdicRepository : PerforRepository<per_dept_dic>
    {
        public IEnumerable<per_dept_dic> GetAccountBasicAccountingUnit(int hospitalId)
        {
            string sql = @"select * from
(
	select distinct
		unittype,
		ifnull
		(
			max(case when source = '门诊' then accountingunit end),
			max(case when source = '住院' then accountingunit end)
		) accountingunit
	from per_dept_dic
	where hospitalid = @hospitalId
	group by unittype,department,hisdeptname
) t
where ifnull(accountingunit, '无')<>'无'
order by unittype,accountingunit;";
            return DapperQuery<per_dept_dic>(sql, new { hospitalId });
        }
    }
}
