﻿using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    public class UnitTypeUtil
    {
        /// <summary>
        /// 是否是行政后勤/工勤
        /// </summary>
        /// <param name="unit"></param>
        /// <returns></returns>
        public static bool IsOffice(int? unit)
        {
            return unit == (int)UnitType.行政后勤;
        }
        /// <summary>
        /// 是否是行政后勤/工勤
        /// </summary>
        /// <param name="unit"></param>
        /// <returns></returns>
        public static bool IsOffice(string unit)
        {
            return !string.IsNullOrEmpty(unit) && (unit == "行政后勤" || unit == "行政工勤");
        }

        /// <summary>
        /// 核算单元类型是否相同
        /// </summary>
        /// <param name="left"></param>
        /// <returns></returns>
        public static bool IsEqualsUnitType(string left, string right)
        {
            return left?.Replace("行政后勤", "行政工勤") == right?.Replace("行政后勤", "行政工勤");
        }
    }
}
