﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Options;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class ConfigController : Controller
    {
        private ConfigService _configService;
        private AllotService _allotService;
        public ConfigController(ConfigService configService, AllotService allotService)
        {
            _configService = configService;
            _allotService = allotService;
        }
        #region 弃用

        //#region director
        ///// <summary>
        ///// 获取规模/效率绩效配置列表
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("directorlist")]
        //[HttpPost]
        //public ApiResponse<List<DirectorResponse>> GetDireList([CustomizeValidator(RuleSet = "Select"), FromBody]DirectorRequest request)
        //{
        //    var list = _configService.GetDireList(request.AllotID);
        //    return new ApiResponse<List<DirectorResponse>>(ResponseType.OK, "ok", list);
        //}

        ///// <summary>
        ///// 新增规模/效率绩效配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("direinsert")]
        //[HttpPost]
        //public ApiResponse<DirectorResponse> DireInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]DirectorRequest request)
        //{
        //    var director = _configService.DireInsert(request);
        //    return new ApiResponse<DirectorResponse>(ResponseType.OK, director);
        //}

        ///// <summary>
        ///// 更新规模/效率绩效配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("direupdate")]
        //[HttpPost]
        //public ApiResponse<DirectorResponse> DireUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]DirectorRequest request)
        //{
        //    var director = _configService.DireUpdate(request);
        //    return new ApiResponse<DirectorResponse>(ResponseType.OK, director);
        //}

        ///// <summary>
        ///// 删除规模/效率绩效配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("diredelete")]
        //[HttpPost]
        //public ApiResponse DireDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]DirectorRequest request)
        //{
        //    if (!_configService.DireDelete(request))
        //        return new ApiResponse(ResponseType.Fail);
        //    return new ApiResponse(ResponseType.OK);
        //}
        //#endregion

        //#region income
        ///// <summary>
        ///// 获取ICU有效收入配置列表
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("incomelist")]
        //[HttpPost]
        //public ApiResponse<List<IncomeResponse>> GetIncomeList([CustomizeValidator(RuleSet = "Select"), FromBody]IncomeRequest request)
        //{
        //    var list = _configService.GetIncomeList(request.AllotID);
        //    return new ApiResponse<List<IncomeResponse>>(ResponseType.OK, "ok", list);
        //}

        ///// <summary>
        ///// 新增ICU有效收入配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("incomeinsert")]
        //[HttpPost]
        //public ApiResponse<IncomeResponse> Insert([CustomizeValidator(RuleSet = "Insert"), FromBody]IncomeRequest request)
        //{
        //    var income = _configService.IncomeInsert(request);
        //    return new ApiResponse<IncomeResponse>(ResponseType.OK, income);
        //}

        ///// <summary>
        ///// 修改ICU有效收入配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("incomeupdate")]
        //[HttpPost]
        //public ApiResponse<IncomeResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody]IncomeRequest request)
        //{
        //    var income = _configService.IncomeUpdate(request);
        //    return new ApiResponse<IncomeResponse>(ResponseType.OK, income);
        //}

        ///// <summary>
        ///// 删除ICU有效收入配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("incomedelete")]
        //[HttpPost]
        //public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody]IncomeRequest request)
        //{
        //    if (!_configService.IncomeDelete(request))
        //        return new ApiResponse(ResponseType.Fail);
        //    return new ApiResponse(ResponseType.OK);
        //}
        //#endregion

        //#region workyear
        ///// <summary>
        ///// 获取年资系数配置列表
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("workyearlist")]
        //[HttpPost]
        //public ApiResponse<List<WorkyearResponse>> GetWorkList([CustomizeValidator(RuleSet = "Select"), FromBody]WorkyearRequest request)
        //{
        //    var list = _configService.GetWorkList(request.AllotID);
        //    return new ApiResponse<List<WorkyearResponse>>(ResponseType.OK, "ok", list);
        //}

        ///// <summary>
        ///// 新增年资系数配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("workinsert")]
        //[HttpPost]
        //public ApiResponse<WorkyearResponse> WorkyearInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]WorkyearRequest request)
        //{
        //    var workyear = _configService.WorkInsert(request);
        //    return new ApiResponse<WorkyearResponse>(ResponseType.OK, workyear);
        //}

        ///// <summary>
        ///// 修改年资系数配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("workupdate")]
        //[HttpPost]
        //public ApiResponse<WorkyearResponse> WorkyearUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]WorkyearRequest request)
        //{
        //    var workyear = _configService.WorkUpdate(request);
        //    return new ApiResponse<WorkyearResponse>(ResponseType.OK, workyear);
        //}

        ///// <summary>
        ///// 删除年资系数配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("workdelete")]
        //[HttpPost]
        //public ApiResponse WorkyearDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]WorkyearRequest request)
        //{
        //    if (!_configService.WorkDelete(request))
        //        return new ApiResponse(ResponseType.Fail);
        //    return new ApiResponse(ResponseType.OK);
        //}
        //#endregion
        #endregion

        #region drugprop
        ///// <summary>
        ///// 获取 药占比配置信息列表
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("drugproplist")]
        //[HttpPost]
        //public ApiResponse<List<DrugpropResponse>> GetDrugList([CustomizeValidator(RuleSet = "Select"), FromBody] DrugpropRequest request)
        //{
        //    var list = _configService.GetDrugList(request.AllotID);
        //    return new ApiResponse<List<DrugpropResponse>>(ResponseType.OK, "ok", list);
        //}

        ///// <summary>
        ///// 新增药占比配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("druginsert")]
        //[HttpPost]
        //public ApiResponse<DrugpropResponse> DrugInsert([CustomizeValidator(RuleSet = "Insert"), FromBody] DrugpropRequest request)
        //{
        //    var drugprop = _configService.DrugInsert(request);
        //    return new ApiResponse<DrugpropResponse>(ResponseType.OK, drugprop);
        //}

        ///// <summary>
        ///// 修改药占比配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("drugupdate")]
        //[HttpPost]
        //public ApiResponse<DrugpropResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody] DrugpropRequest request)
        //{
        //    var drugprop = _configService.DrugUpdate(request);
        //    return new ApiResponse<DrugpropResponse>(ResponseType.OK, drugprop);
        //}

        ///// <summary>
        ///// 删除药占比配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("drugdelete")]
        //[HttpPost]
        //public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody] DrugpropRequest request)
        //{
        //    if (!_configService.DrugDelete(request))
        //        return new ApiResponse(ResponseType.Fail);
        //    return new ApiResponse(ResponseType.OK);
        //}
        #endregion

        #region drugtype
        /// <summary>
        /// 获取 药占比类型信息列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypelist")]
        [HttpPost]
        public ApiResponse GetDrugtypeList([CustomizeValidator(RuleSet = "Select"), FromBody] DrugpropRequest request)
        {
            var list = _configService.GetDrugtypeList(request.HospitalId, request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypeinsert")]
        [HttpPost]
        public ApiResponse DrugtypeInsert([CustomizeValidator(RuleSet = "Insert"), FromBody] DrugpropRequest request)
        {
            var drugprop = _configService.DrugtypeInsert(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 修改药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypeupdate")]
        [HttpPost]
        public ApiResponse DrugtypeUpdate([CustomizeValidator(RuleSet = "Update"), FromBody] DrugpropRequest request)
        {
            var drugprop = _configService.DrugtypeUpdate(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 删除药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypedelete")]
        [HttpPost]
        public ApiResponse DrugtypeDelete([CustomizeValidator(RuleSet = "Delete"), FromBody] DrugpropRequest request)
        {
            if (!_configService.DrugtypeDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region cofagain
        /// <summary>
        /// 获取二次绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagainlist")]
        [HttpPost]
        public ApiResponse GetAgainList([CustomizeValidator(RuleSet = "Select"), FromBody] CofAgainRequest request)
        {
            var list = _configService.GetAgainList(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagaininsert")]
        [HttpPost]
        public ApiResponse AgainInsert([CustomizeValidator(RuleSet = "Insert"), FromBody] CofAgainRequest request)
        {
            var workyear = _configService.AgainInsert(request);
            return new ApiResponse(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 修改二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagainupdate")]
        [HttpPost]
        public ApiResponse AgainUpdate([CustomizeValidator(RuleSet = "Update"), FromBody] CofAgainRequest request)
        {
            var workyear = _configService.AgainUpdate(request);
            return new ApiResponse(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 删除二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagaindelete")]
        [HttpPost]
        public ApiResponse AgainDelete([CustomizeValidator(RuleSet = "Delete"), FromBody] CofAgainRequest request)
        {
            if (!_configService.AgainDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region workitem
        /// <summary>
        /// 获取工作量绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemlist")]
        [HttpPost]
        public ApiResponse<List<cof_workitem>> GetWorkItems([CustomizeValidator(RuleSet = "Select"), FromBody] WorkItemRequest request)
        {
            var list = _configService.GetWorkItems(request.AllotID, request.Type);
            return new ApiResponse<List<cof_workitem>>(ResponseType.OK, "ok", list);
        }

        /// <summary> 
        /// 新增工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workiteminsert")]
        [HttpPost]
        public ApiResponse<cof_workitem> WorkItemInsert([CustomizeValidator(RuleSet = "Insert"), FromBody] WorkItemRequest request)
        {
            var workyear = _configService.WorkItemInsert(request);
            return new ApiResponse<cof_workitem>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 修改工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemupdate")]
        [HttpPost]
        public ApiResponse<cof_workitem> WorkItemUpdate([CustomizeValidator(RuleSet = "Update"), FromBody] WorkItemRequest request)
        {
            var workyear = _configService.WorkItemUpdate(request);
            return new ApiResponse<cof_workitem>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 删除工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemdelete")]
        [HttpPost]
        public ApiResponse WorkItemDelete([CustomizeValidator(RuleSet = "Delete"), FromBody] WorkItemRequest request)
        {
            if (!_configService.WorkItemkDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region depttype
        /// <summary>
        /// 获取 药占比类型信息列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("deptlist")]
        [HttpPost]
        public ApiResponse GetDepttypeList([CustomizeValidator(RuleSet = "Select"), FromBody] DrugpropRequest request)
        {
            var list = _configService.GetDepttypeList(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("deptinsert")]
        [HttpPost]
        public ApiResponse DepttypeInsert([CustomizeValidator(RuleSet = "Insert"), FromBody] DrugpropRequest request)
        {
            var drugprop = _configService.DepttypeInsert(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 修改药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("deptupdate")]
        [HttpPost]
        public ApiResponse DepttypeUpdate([CustomizeValidator(RuleSet = "Update"), FromBody] DrugpropRequest request)
        {
            var drugprop = _configService.DepttypeUpdate(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 删除药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("deptdelete")]
        [HttpPost]
        public ApiResponse DepttypeDelete([CustomizeValidator(RuleSet = "Delete"), FromBody] DrugpropRequest request)
        {
            if (!_configService.DepttypeDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region cmi
        ///// <summary>
        ///// 获取 CMI配置信息
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("cmilist")]
        //[HttpPost]
        //public ApiResponse GetHosCMIList([FromBody] cof_cmi request)
        //{
        //    var list = _configService.GetCMIList(request.AllotId);
        //    return new ApiResponse(ResponseType.OK, "ok", list);
        //}

        ///// <summary>
        ///// 新增 CMI配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("cmiinsert")]
        //[HttpPost]
        //public ApiResponse HosCMIInsert([FromBody] cof_cmi request)
        //{
        //    var drugprop = _configService.HosCMIInsert(request);
        //    return new ApiResponse(ResponseType.OK, drugprop);
        //}

        ///// <summary>
        ///// 修改 CMI配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("cmiupdate")]
        //[HttpPost]
        //public ApiResponse HosCMIUpdate([FromBody] cof_cmi request)
        //{
        //    var drugprop = _configService.HosCMIUpdate(request);
        //    return new ApiResponse(ResponseType.OK, drugprop);
        //}

        ///// <summary>
        ///// 删除 CMI配置
        ///// </summary>
        ///// <param name="request"></param>
        ///// <returns></returns>
        //[Route("cmidelete")]
        //[HttpPost]
        //public ApiResponse HosCMIDelete([FromBody] cof_cmi request)
        //{
        //    if (!_configService.HosCMIDelete(request))
        //        return new ApiResponse(ResponseType.Fail);
        //    return new ApiResponse(ResponseType.OK);
        //}
        #endregion

        #region accounting
        /// <summary>
        /// 获取cof_accounting列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("accountinglist")]
        [HttpPost]
        public ApiResponse GetAccountingList([FromBody] AccoungingRequest request)
        {
            var enumItems = EnumHelper.GetItems<AccountTypeEnum>();
            if (request.AllotId == 0 || !enumItems.Select(t => t.Value).Contains(request.Type))
                return new ApiResponse(ResponseType.ParameterError);

            var result = _configService.GetAccountingList(request);
            switch (request.Type)
            {
                case (int)AccountTypeEnum.List:     //返回accounting列表
                default:
                    return new ApiResponse(ResponseType.OK, AccountTypeEnum.List.ToString(), result);

                case (int)AccountTypeEnum.UnitType:     //返回核算单元类型
                    var unittypes = result.Select(t => new TitleValue { Title = t.UnitType, Value = t.UnitType }).ToDistinct();
                    return new ApiResponse(ResponseType.OK, AccountTypeEnum.UnitType.ToString(), unittypes);

                case (int)AccountTypeEnum.AccountingUnit:     //返回核算单元
                    var accountingunits = result.Select(t => new TitleValue { Title = t.AccountingUnit, Value = t.AccountingUnit }).ToDistinct();
                    return new ApiResponse(ResponseType.OK, AccountTypeEnum.AccountingUnit.ToString(), accountingunits);
            }
        }

        /// <summary>
        /// 新增cof_accounting
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("accountinginsert")]
        [HttpPost]
        public ApiResponse AccountingInsert([FromBody] cof_accounting request)
        {
            if (request.AllotId == 0 || string.IsNullOrEmpty(request.UnitType) || string.IsNullOrEmpty(request.AccountingUnit))
                return new ApiResponse(ResponseType.ParameterError);

            var drugprop = _configService.AccountingInsert(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 修改cof_accounting
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("accountingupdate")]
        [HttpPost]
        public ApiResponse AccountingUpdate([FromBody] cof_accounting request)
        {
            if (request.AllotId == 0 || string.IsNullOrEmpty(request.UnitType) || string.IsNullOrEmpty(request.AccountingUnit))
                return new ApiResponse(ResponseType.ParameterError);

            var drugprop = _configService.AccountingUpdate(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 删除cof_accounting
        /// </summary>
        /// <param name="accountingId"></param>
        /// <returns></returns>
        [Route("accountingdelete/{accountingId}")]
        [HttpPost]
        public ApiResponse AccountingDelete([FromRoute] int accountingId)
        {
            if (!_configService.AccountingDelete(accountingId))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }


        /// <summary>
        /// 核算单元及组别批量表头
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        [Route("BatchAccountingStructrue/{allotId}")]
        [HttpPost]
        public ApiResponse BatchAccountingStructrue([FromRoute] int allotId)
        {
            var request = _configService.GetBatchAccountingStructrue(allotId);
            return new ApiResponse(ResponseType.OK, request);
        }

        /// <summary>
        /// 核算单元及组别批量添加
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        [Route("BatchSaveAccounting/{allotId}")]
        [HttpPost]
        public ApiResponse BatchSaveAccounting(int allotId, [FromBody] SaveCollectData request)
        {
            var result = _configService.BatchSaveAccounting(allotId, request);
            if (result)
                return new ApiResponse(ResponseType.OK);
            else
                return new ApiResponse(ResponseType.Error, "请选择正确的核算组别");
        }


        #endregion

        /// <summary>
        /// 获取工作量绩效列头
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workheader")]
        [HttpPost]
        public ApiResponse WorkHeader([CustomizeValidator(RuleSet = "Select"), FromBody] WorkItemRequest request)
        {
            var list = _configService.WorkHeader(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        #region HRP人员科室

        /// <summary>
        /// 获取HRP人员科室
        /// </summary>
        /// <param name="hospitalId"></param>
        /// <param name="allotId"></param>
        /// <returns></returns>
        [Route("hrpdepthands/{hospitalId}/allot/{allotId}")]
        [HttpPost]
        public ApiResponse GetHrpDeptHands([FromRoute] int hospitalId, int allotId)
        {
            if (hospitalId <= 0)
                return new ApiResponse(ResponseType.Fail, "参数错误", "HospitalId无效");
            if (allotId <= 0)
                return new ApiResponse(ResponseType.Fail, "参数错误", "allotid无效");

            var relust = _configService.GetHrpDeptHands(hospitalId, allotId);
            return new ApiResponse(ResponseType.OK, relust);
        }

        /// <summary>
        /// 保存HRP人员科室
        /// </summary>
        /// <param name=""></param>
        /// <returns></returns>
        [Route("savehrpdept/{hospitalId}/allot/{allotId}")]
        [HttpPost]
        public ApiResponse SaveHrpDept(int hospitalId, int allotId, [FromBody] SaveCollectData request)
        {
            if (hospitalId <= 0)
                return new ApiResponse(ResponseType.Fail, "参数错误", "HospitalId无效");
            if (allotId <= 0)
                return new ApiResponse(ResponseType.Fail, "参数错误", "allotid无效");
            _configService.SaveDepttypeHands(hospitalId, allotId, request);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region 二次分配别名配置

        /// <summary>
        /// 获取二次分配别名配置
        /// </summary>
        /// <returns></returns>
        [Route("secondaryAlias")]
        [HttpPost]
        public ApiResponse GetSecondaryAlias()
        {
            var relust = _configService.GetSecondaryAlias();
            return new ApiResponse(ResponseType.OK, relust);
        }

        /// <summary>
        /// 保存二次分配别名配置
        /// </summary>
        /// <returns></returns>
        [Route("saveSecondaryAlias")]
        [HttpPost]
        public ApiResponse SaveSecondaryAlias([FromBody] SaveCollectData request)
        {

            _configService.SaveSecondaryAlias(request);
            return new ApiResponse(ResponseType.OK);
        }

        #endregion
    }
}