﻿using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class CostTransferController : Controller
    {
        private readonly CostTransferService costTransferService;
        private readonly ClaimService claim;
        private readonly RoleService roleService;
        private readonly UserService userService;

        public CostTransferController(
            CostTransferService costTransferService,
            ClaimService claim,
            RoleService roleService,
            UserService userService)

        {
            this.costTransferService = costTransferService;
            this.claim = claim;
            this.roleService = roleService;
            this.userService = userService;
        }
        /// <summary>
        /// 申请划拨
        /// </summary>
        /// <returns></returns>
        [Route("submit")]
        [HttpPost]
        public ApiResponse SubmitApplications([FromBody] CostTransferRequest request)
        {
            if (request.AllotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var result = costTransferService.Applicat(request);
            return new ApiResponse(ResponseType.OK, result);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Route("common/{hospitalId}/allot/{allotId}")]
        [HttpPost]
        public ApiResponse Common(int hospitalId, int allotId, [FromBody] DepartmentDetail detail)
        {
            if (hospitalId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数HospitalId无效！");
            if (allotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var userid = claim.GetUserId();
            var user = userService.GetUser(userid);
            var role = roleService.GetARole(user.UserID);

            var result = costTransferService.Common(allotId, hospitalId, role.Type.Value, user.Department, detail);

            result.deparment = user.Department ?? "";
            return new ApiResponse(ResponseType.OK, result);
        }

        /// <summary>
        /// 当前科室、类别
        /// </summary>
        /// <returns></returns>
        [Route("deptdetial/{hospitalId}/allot/{allotId}")]
        [HttpPost]
        public ApiResponse DeptDetial(int hospitalId, int allotId)
        {
            if (hospitalId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数HospitalId无效！");
            if (allotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var userid = claim.GetUserId();
            var user = userService.GetUser(userid);
            var role = roleService.GetARole(user.UserID);

            var result = costTransferService.DeptDetial(allotId, hospitalId, role.Type.Value, user.Department);

            result.Item2.Department = user.Department ?? "";
            return new ApiResponse(ResponseType.OK, result.Item2);
        }

        /// <summary>
        /// 撤回提交
        /// </summary>
        /// <param name="itemId"></param>
        /// <returns></returns>
        [Route("withdrawsubmit/{itemId}")]
        [HttpPost]
        public ApiResponse WithdrawSubmit(int itemId)
        {
            if (itemId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数itemId无效!");

            costTransferService.WithdrawSubmit(itemId);
            return new ApiResponse(ResponseType.OK);
        }

        /// <summary>
        /// 审核列表
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="menuType"></param>
        /// <returns></returns>
        [Route("auditlist/{allotId}/menuType/{menuType}")]
        [HttpPost]
        public ApiResponse AuditList(int allotId, int menuType)
        {
            if (allotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var userid = claim.GetUserId();
            var user = userService.GetUser(userid);
            var role = roleService.GetARole(user.UserID);
            var result = costTransferService.GetAuditList(allotId, menuType, role.Type.Value, user.Department);

            return new ApiResponse(ResponseType.OK, result);

        }

        /// <summary>
        /// 划拨审核
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("costtransferaudit")]
        [HttpPost]
        public ApiResponse Audit([FromBody] AuditRequest request)
        {
            if (request.AllotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var userid = claim.GetUserId();
            var user = userService.GetUser(userid);
            var role = roleService.GetARole(user.UserID);
            var roleArr = new[] { 1, 2, 5 };

            if (roleArr.Contains(role.Type.Value))
                costTransferService.CostTransferAudit(request, true);
            else
                costTransferService.CostTransferAudit(request, false);
            return new ApiResponse(ResponseType.OK);
        }

        /// <summary>
        /// 驳回修改
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("updateapplicat")]
        [HttpPost]
        public ApiResponse UpdateApplicat([FromBody] CostTransferUpdateRequest request)
        {
            if (request.AllotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            costTransferService.UpdateApplicat(request);
            return new ApiResponse(ResponseType.OK);
        }

        /// <summary>
        /// 划拨报表
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="auditType"></param>
        /// <param name="detail"></param>
        /// <returns></returns>
        [Route("transfercontent/{allotId}/auditType/{auditType}")]
        [HttpPost]
        public ApiResponse TransferContent(int allotId,int auditType ,[FromBody] DepartmentDetail detail)
        {
            if (allotId <= 0)
                return new ApiResponse(ResponseType.ParameterError, "参数AllotId无效！");

            var result=costTransferService.TransferContent(allotId,auditType,detail);

            return new ApiResponse(ResponseType.OK,result);
        }
    }
}
