﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class AssessRequest
    {
        public int AssessID { get; set; }
        public int AllotID { get; set; }
        public string AssessName { get; set; }
    }

    public class AssessRequestValidator : AbstractValidator<AssessRequest>
    {
        public AssessRequestValidator()
        {
            RuleSet("Del", () =>
            {
                RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
            });

            RuleSet("Update", () =>
            {
                RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
                RuleFor(t => t.AssessName).NotNull().NotEmpty();
            });

            RuleSet("Add", () =>
            {
                RuleFor(t => t.AllotID).NotNull().NotEmpty();
                RuleFor(t => t.AssessName).NotNull().NotEmpty();
            });

            RuleSet("List", () =>
            {
                RuleFor(t => t.AllotID).NotNull().NotEmpty();
            });

            RuleSet("Use", () =>
            {
                RuleFor(t => t.AllotID).NotNull().NotEmpty();
                RuleFor(t => t.AssessID).NotNull().NotEmpty();
            });
        }
    }
}
