﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class SubmitAuditRequest
    {
        public int SecondId { get; set; }
        /// <summary>
        /// 提交类型 1 模板提交 2 其他提交
        /// </summary>
        public int Type { get; set; }
    }
    public class SubmitAuditRequestValidator : AbstractValidator<SubmitAuditRequest>
    {
        public SubmitAuditRequestValidator()
        {
            RuleFor(x => x.Type).InclusiveBetween(1, 2);

            RuleFor(x => x.SecondId).GreaterThan(0);
        }
    }
}
