//-----------------------------------------------------------------------
// <copyright file=" rep_selection.cs">
// * FileName: 条件表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 条件表
    /// </summary>
    [Table("rep_selection")]
    public class rep_selection
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 条件标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public Nullable<decimal> Sort { get; set; }

        /// <summary>
        /// 条件SQL语句
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 条件类型（1固定条件，2需要通过语句获取）
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 控件名称
        /// </summary>
        public string InputName { get; set; }

        /// <summary>
        /// 控件类型（1：input框、2：radio单选、3：checkbox多选、4：select单选、5：select多选、6：自动补全单选、7：自动补全多选、10：日期区间）
        /// </summary>
        public string InputType { get; set; }

        /// <summary>
        /// 是否必填(1表示必填0表示非必填）
        /// </summary>
        public Nullable<int> Required { get; set; }

        /// <summary>
        /// 条件加载方式 1 立即加载 2 联动加载 3 自动补全
        /// </summary>
        public int LoadType { get; set; }

        /// <summary>
        /// 联动加载父InputID
        /// </summary>
        public string LoadParent { get; set; }

        /// <summary>
        /// 默认值类型(1 固定文本 2 动态结果第一项)
        /// </summary>
        public Nullable<int> DefaultType { get; set; }

        /// <summary>
        /// 默认值文本
        /// </summary>
        public string DefaultValue { get; set; }

        /// <summary>
        /// SQL拼接条件 Equal、Like、In、Not Like、Not In
        /// </summary>
        public string Joint { get; set; }

        /// <summary>
        /// 条件状态 1 正常 2 可用但不显示 3 不显示不可用 4 不可用但显示
        /// </summary>
        public Nullable<int> State { get; set; }

        /// <summary>
        /// 是否条件内容附加到标题中，1 附加
        /// </summary>
        public Nullable<int> AddTitle { get; set; }
    }
}
