//-----------------------------------------------------------------------
// <copyright file=" sys_role.cs">
// * FileName: 角色表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 角色表
    /// </summary>
    [Table("sys_role")]
    public class sys_role
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 角色名称
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// 角色类型 3 护士长二次绩效管理员 4 科主任二次绩效管理员
        /// </summary>
        public Nullable<int> Type { get; set; }

        /// <summary>
        /// 首页地址
        /// </summary>
        public string IndexUrl { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 菜单状态 1 启用 2禁用
        /// </summary>
        public int States { get; set; }

        /// <summary>
        /// 父级角色
        /// </summary>
        public string ParentRoles { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> Sort { get; set; }

        /// <summary>
        /// 是否查看所有用户 1 启用 2禁用
        /// </summary>
        public Nullable<int> IsViewAllUsers { get; set; }
    }
}
