//-----------------------------------------------------------------------
// <copyright file=" per_employee.cs">
// * FileName: per_employee.cs
// </copyright>
//-----------------------------------------------------------------------
using Microsoft.EntityFrameworkCore;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure.Models;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;

namespace Performance.Repository
{
    /// <summary>
    /// per_employee Repository
    /// </summary>
    public partial class PerforPeremployeeRepository : PerforRepository<per_employee>
    {

        public new PageList<per_employee> GetEntitiesForPaging(int pageNumber, int pageSize, Expression<Func<per_employee, bool>> exp)
        {
            IQueryable<per_employee> queryableAuthors = context.Set<per_employee>().Where(exp).OrderBy(w => w.IsVerify).ThenBy(t => t.Id);

            return PageList<per_employee>.Create(queryableAuthors, pageNumber, pageSize);
        }


        public Comparison GetComparison(ComparisonPagingRequest request)
        {
            var search = "";
            if (string.IsNullOrEmpty(request.SearchQuery))
                search = " 1=1 ";
            else
            {
                if (request.ViewName == "view_check_dept")
                    search = $" ( AccountingUnit like '%{request.SearchQuery}%' )";
                else
                    search = $" ( AccountingUnit like '%{request.SearchQuery}%' or JobNumber like '%{request.SearchQuery}%' or EmployeeName like '%{request.SearchQuery}%') ";
            }


            var result = new Comparison();
            var sql = $@"SELECT COUNT(*) FROM {request.ViewName} WHERE AllotId = @AllotId and {search}";
            result.TotalCount = DapperQuery<int>(sql, new { request.AllotId })?.FirstOrDefault() ?? 0;

            sql = $@"SELECT * FROM {request.ViewName} WHERE AllotId = @AllotId and {search} ORDER BY HospitalId,Year,Month,ABS(DIFF) DESC LIMIT {(request.PageIndex - 1) * request.PageSize},{request.PageSize}; ";

            result.Datas = DapperQuery<view_check_emp>(sql, new { request.AllotId })?.ToList();
            return result;
        }
    }


}
