
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using System;
using Performance.EntityModels.Entity;

namespace Performance.EntityModels
{
    public partial class PerformanceDbContext : DbContext
    {
        public PerformanceDbContext(DbContextOptions<PerformanceDbContext> options)
            : base(options)
        {
        }

		/// <summary> 二次分配概览 </summary>
        public virtual DbSet<ag_againsituation> ag_againsituation { get; set; }
        /// <summary> 二次绩效保存数据 </summary>
        public virtual DbSet<ag_bodysource> ag_bodysource { get; set; }
        /// <summary> 二次绩效结果表 </summary>
        public virtual DbSet<ag_compute> ag_compute { get; set; }
		/// <summary> 二次分配不固定数据 </summary>
        public virtual DbSet<ag_data> ag_data { get; set; }
		/// <summary> 二次分配人员名单 </summary>
        public virtual DbSet<ag_employee> ag_employee { get; set; }
		/// <summary> 二次绩效固定项 </summary>
        public virtual DbSet<ag_fixatitem> ag_fixatitem { get; set; }
		/// <summary> 二次分配不固定列头数据 </summary>
        public virtual DbSet<ag_header> ag_header { get; set; }
        /// <summary> 二次绩效顶部数据 </summary>
        public virtual DbSet<ag_headsource> ag_headsource { get; set; }
        /// <summary> 科室二次绩效录入内容 </summary>
        public virtual DbSet<ag_itemvalue> ag_itemvalue { get; set; }
		/// <summary> 二次绩效其他绩效来源 </summary>
        public virtual DbSet<ag_othersource> ag_othersource { get; set; }
		/// <summary> 二次绩效列表 </summary>
        public virtual DbSet<ag_secondallot> ag_secondallot { get; set; }
		/// <summary> 二次绩效模板 </summary>
        public virtual DbSet<ag_temp> ag_temp { get; set; }
		/// <summary> 二次绩效模板项 </summary>
        public virtual DbSet<ag_tempitem> ag_tempitem { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ag_usetemp> ag_usetemp { get; set; }
		/// <summary> 二次绩效工作量绩效 </summary>
        public virtual DbSet<ag_workload> ag_workload { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<ag_workload_source> ag_workload_source { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<ag_workload_type> ag_workload_type { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<ag_worktype_source> ag_worktype_source { get; set; }
        /// <summary> 考核类别 </summary>
        public virtual DbSet<as_assess> as_assess { get; set; }
		/// <summary> 考核列头 </summary>
        public virtual DbSet<as_columns> as_columns { get; set; }
		/// <summary> 考核数据 </summary>
        public virtual DbSet<as_data> as_data { get; set; }
		/// <summary> 考核类别 </summary>
        public virtual DbSet<as_tempassess> as_tempassess { get; set; }
		/// <summary> 考核列头 </summary>
        public virtual DbSet<as_tempcolumns> as_tempcolumns { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<cof_accounting> cof_accounting { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<cof_again> cof_again { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<cof_alias> cof_alias { get; set; }
        /// <summary> 上传excel文件校验配置 </summary>
        public virtual DbSet<cof_check> cof_check { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<cof_cmi> cof_cmi { get; set; }
		/// <summary> 科室类型 </summary>
        public virtual DbSet<cof_depttype> cof_depttype { get; set; }
		/// <summary> 规模绩效、效率绩效计算系数配置 </summary>
        public virtual DbSet<cof_director> cof_director { get; set; }
		/// <summary> 工作量门诊药占比系数 </summary>
        public virtual DbSet<cof_drugprop> cof_drugprop { get; set; }
		/// <summary> 药占比费用列头名称 </summary>
        public virtual DbSet<cof_drugtype> cof_drugtype { get; set; }
		/// <summary> 保底科室配置 </summary>
        public virtual DbSet<cof_guarantee> cof_guarantee { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<cof_hrp_department> cof_hrp_department { get; set; }
		/// <summary> ICU医生护士有效收入汇总计算系数 </summary>
        public virtual DbSet<cof_income> cof_income { get; set; }
		/// <summary> 特殊绩效项指标 </summary>
        public virtual DbSet<cof_singlefactor> cof_singlefactor { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<cof_workitem> cof_workitem { get; set; }
		/// <summary> 工作量分类 </summary>
        public virtual DbSet<cof_workloadtype> cof_workloadtype { get; set; }
		/// <summary> 工龄对应绩效系数配置 </summary>
        public virtual DbSet<cof_workyear> cof_workyear { get; set; }
        
        /// <summary>  </summary>
        public virtual DbSet<collect_data> collect_data { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<collect_permission> collect_permission { get; set; }
		/// <summary> 自定义导出 </summary>
        public virtual DbSet<cust_script> cust_script { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_item> ex_item { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_module> ex_module { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_result> ex_result { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_script> ex_script { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_special> ex_special { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ex_type> ex_type { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<his_data> his_data { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<his_import_account> his_import_account { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<his_import_baiscnorm> his_import_baiscnorm { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<his_import_clinic> his_import_clinic { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<his_importdata> his_importdata { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<his_script> his_script { get; set; }
        /// <summary>  </summary>
        public virtual DbSet<hos_personfee> hos_personfee { get; set; }
		/// <summary> 科室核算导入信息 </summary>
        public virtual DbSet<im_accountbasic> im_accountbasic { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_data> im_data { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_employee> im_employee { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_employee_clinic> im_employee_clinic { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_employee_logistics> im_employee_logistics { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_header> im_header { get; set; }
		/// <summary> 特殊科室核算 </summary>
        public virtual DbSet<im_specialunit> im_specialunit { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<log_check> log_check { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<log_dbug> log_dbug { get; set; }
		/// <summary> 部分公共数据抽取SQL </summary>
        public virtual DbSet<mod_dic> mod_dic { get; set; }
		/// <summary> 医院数据提取脚本 </summary>
        public virtual DbSet<mod_extract> mod_extract { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_item> mod_item { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_module> mod_module { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_special> mod_special { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<per_againallot> per_againallot { get; set; }
		/// <summary> 医院绩效分配 </summary>
        public virtual DbSet<per_allot> per_allot { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<per_apr_amount> per_apr_amount { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<per_apr_amount_hide> per_apr_amount_hide { get; set; }
		/// <summary> 预算管理金额 </summary>
        public virtual DbSet<per_budget_amount> per_budget_amount { get; set; }
		/// <summary> 预算管理占比 </summary>
        public virtual DbSet<per_budget_ratio> per_budget_ratio { get; set; }
		/// <summary> 预算控制年度合计 </summary>
        public virtual DbSet<per_budget_result> per_budget_result { get; set; }
		/// <summary> 科室字典表 </summary>
        public virtual DbSet<per_dept_dic> per_dept_dic { get; set; }
		/// <summary> 绩效人员表 </summary>
        public virtual DbSet<per_employee> per_employee { get; set; }
		/// <summary> 首次上传文件地址（当医院存在标准库时，首次上传用户提交固定格式的excel，开发人员配置SQL脚本） </summary>
        public virtual DbSet<per_first> per_first { get; set; }
		/// <summary> 上传数据解析 </summary>
        public virtual DbSet<per_sheet> per_sheet { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<rep_group> rep_group { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<rep_group_selection> rep_group_selection { get; set; }
		/// <summary> 导入报表SQL配置 </summary>
        public virtual DbSet<rep_importconfig> rep_importconfig { get; set; }
		/// <summary> 报表配置表 </summary>
        public virtual DbSet<rep_report> rep_report { get; set; }
		/// <summary> 条件表 </summary>
        public virtual DbSet<rep_selection> rep_selection { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<report_global> report_global { get; set; }
		/// <summary> 医院门诊住院人次 </summary>
        public virtual DbSet<report_original_persontime> report_original_persontime { get; set; }
		/// <summary> 医院门诊住院人次 </summary>
        public virtual DbSet<report_original_stays> report_original_stays { get; set; }
		/// <summary> 医院手术人次 </summary>
        public virtual DbSet<report_original_surgery> report_original_surgery { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<report_original_workload> report_original_workload { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<report_performance_person_tags> report_performance_person_tags { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<report_performance_tags> report_performance_tags { get; set; }
		/// <summary> 科室核算结果 </summary>
        public virtual DbSet<res_account> res_account { get; set; }
		/// <summary> 医生科室核算结果 </summary>
        public virtual DbSet<res_accountdoctor> res_accountdoctor { get; set; }
		/// <summary> 护理科室核算结果 </summary>
        public virtual DbSet<res_accountnurse> res_accountnurse { get; set; }
		/// <summary> 核算基础标准 </summary>
        public virtual DbSet<res_baiscnorm> res_baiscnorm { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<res_compute> res_compute { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<res_reserved> res_reserved { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<res_specialunit> res_specialunit { get; set; }
		/// <summary> 医院数据提取脚本 </summary>
        public virtual DbSet<sys_extract> sys_extract { get; set; }
		/// <summary> 医院信息 </summary>
        public virtual DbSet<sys_hospital> sys_hospital { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_hospitalconfig> sys_hospitalconfig { get; set; }
		/// <summary> 菜单表 </summary>
        public virtual DbSet<sys_menu> sys_menu { get; set; }
		/// <summary> 角色表 </summary>
        public virtual DbSet<sys_role> sys_role { get; set; }
		/// <summary> 角色菜单关联表 </summary>
        public virtual DbSet<sys_role_menu> sys_role_menu { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_sms> sys_sms { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_task> sys_task { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_user> sys_user { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_user_hospital> sys_user_hospital { get; set; }
		/// <summary> 用户角色关联表 </summary>
        public virtual DbSet<sys_user_role> sys_user_role { get; set; }
    }
}
