﻿namespace Performance.EntityModels
{
    public class view_per_apr_amount : per_apr_amount
    {
        /// <summary>
        /// 核算单元组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    }
    public class view_per_total_amount
    {
        public view_per_total_amount() { }

        public view_per_total_amount(string unitType, string accountingUnit, string personnelNumber, decimal amount, bool use = false)
        {
            UnitType = unitType;
            AccountingUnit = accountingUnit;
            PersonnelNumber = personnelNumber;
            Amount = amount;
            Use = use;
        }

        /// <summary>
        /// 核算单元组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }
        /// <summary>
        /// 医院其他绩效
        /// </summary>
        public decimal Amount { get; set; }
        /// <summary>
        /// 是否被使用 默认false
        /// </summary>
        public bool Use { get; set; }
    }
}
