﻿using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace Performance.Infrastructure
{
    public static partial class UtilExtensions
    {
        /// <summary>
        /// 获取键值对指定key值，并进行类型转换
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="keyValues"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static T GetValue<T>(this Dictionary<string, object> keyValues, string key, T defaultValue = default(T))
        {
            if (keyValues.TryGetValue(key, out object value))
                return ConvertHelper.To<T>(value, defaultValue);
            else if (keyValues.TryGetValue(key.ToLower(), out value))
                return ConvertHelper.To<T>(value, defaultValue);
            return defaultValue;
        }

        /// <summary>
        /// 获取键值对指定key值，并进行类型转换
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="keyValues"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static T GetValue<T>(this SortedDictionary<string, object> keyValues, string key, T defaultValue = default(T))
        {
            if (keyValues.TryGetValue(key, out object value))
                return ConvertHelper.To<T>(value, defaultValue);
            else if (keyValues.TryGetValue(key.ToLower(), out value))
                return ConvertHelper.To<T>(value, defaultValue);
            return defaultValue;
        }

        /// <summary>
        /// 添加或修改
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="keyValues"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static void AddOrUpdate(this Dictionary<string, object> keyValues, string key, object value)
        {
            var pair = keyValues.FirstOrDefault(w => w.Key.Equals(key, StringComparison.OrdinalIgnoreCase));
            if (default(KeyValuePair<string, object>).Equals(pair))
                keyValues.Add(key, value);
            else
                keyValues[key] = value;
        }

        /// <summary>
        /// 为了快速读取，忽略大小写，默认：0
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="keyValues"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static decimal GetDecimal(this Dictionary<string, object> keyValues, string key)
        {
            if (keyValues.TryGetValue(key, out object value))
                return value == null ? 0m : decimal.Parse(value.ToString());
            else if (keyValues.TryGetValue(key.ToLower(), out value))
                return value == null ? 0m : decimal.Parse(value.ToString());
            return 0m;
        }

        /// <summary>
        /// 为了快速读取，忽略大小写，默认：空值
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="keyValues"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetString(this Dictionary<string, object> keyValues, string key)
        {
            if (keyValues.TryGetValue(key, out object value))
                return value?.ToString() ?? "";
            else if (keyValues.TryGetValue(key.ToLower(), out value))
                return value?.ToString() ?? "";
            return "";
        }

        /// <summary>
        /// form 转换 键值对
        /// </summary>
        /// <param name="pairs"></param>
        /// <returns></returns>
        public static SortedDictionary<string, object> ToDictionary(this IFormCollection pairs)
        {
            SortedDictionary<string, object> kv = new SortedDictionary<string, object>();
            if (pairs == null || pairs.Keys.Count == 0)
                return kv;
            foreach (var item in pairs.Keys)
            {
                kv.Add(item, pairs[item].FirstOrDefault());
            }
            return kv;
        }
    }
}