//-----------------------------------------------------------------------
// <copyright file=" per_apr_amount.cs">
// * FileName: per_apr_amount.cs
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// per_apr_amount_hide Repository
    /// </summary>
    public partial class PerforPerapramounthideRepository : PerforRepository<per_apr_amount_hide>
    {
        public List<view_per_apr_amount> GetFullAmount(Expression<Func<per_apr_amount_hide, bool>> predicate)
        {
            var amounts = GetEntities(predicate);
            if (amounts == null || !amounts.Any())
                return new List<view_per_apr_amount>();

            var ids = amounts.Select(w => w.AllotId).Distinct().ToList();

            var employees = this.context.Set<per_employee>()
                .Where(w => w.AllotId.HasValue && ids.Contains(w.AllotId.Value))
                .Select(w => new
                {
                    UnitType = w.UnitType,
                    AccountingUnit = w.AccountingUnit,
                    AllotId = w.AllotId,
                    PersonnelNumber = w.PersonnelNumber,
                });

            var res = from outer in amounts
                      join inner in employees
                      on new { outer.AllotId, outer.PersonnelNumber } equals new { AllotId = inner.AllotId ?? 0, inner.PersonnelNumber } into temp
                      from tt in temp.DefaultIfEmpty()
                      select new view_per_apr_amount
                      {
                          Id = outer.Id,
                          AllotId = outer.AllotId,
                          PersonnelNumber = outer.PersonnelNumber,
                          DoctorName = outer.DoctorName,
                          PerforType = outer.PerforType,
                          Amount = outer.Amount,
                          AccountingUnit = tt?.AccountingUnit ?? "",
                          UnitType = tt?.UnitType ?? "",
                          TypeInDepartment = outer.TypeInDepartment,
                          Status = outer.Status,
                          AuditTime = outer.AuditTime,
                          AuditUser = outer.AuditUser,
                          CreateDate = outer.CreateDate,
                          CreateUser = outer.CreateUser,
                          Remark = outer.Remark,
                          IsVerify = outer.IsVerify,
                          VerifyMessage = outer.VerifyMessage,
                      };
            return res.ToList() ?? new List<view_per_apr_amount>();
        }
    }
}
