﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels.Request
{
    public class BatchCancelRequest
    {
        public int HospitalId { get; set; }

        public int AllotId { get; set; }

        public List<BatchDetail> Details { get; set; }
    }
    public class BatchRequest
    {
        public int HospitalId { get; set; }

        public int AllotId { get; set; }
        /// <summary>
        /// 批次号
        /// </summary>
        public string Batch { get; set; }
        /// <summary>
        /// 发放时间
        /// </summary>
        public DateTime? BatchDate { get; set; }
        /// <summary>
        /// 发放银行
        /// </summary>
        public string BankName { get; set; }

        public List<BatchDetail> Details { get; set; }
    }

    public class BatchDetail
    {
        /// <summary>
        /// 核算单元分类
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 人员姓名
        /// </summary>
        public string EmployeeName { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }
    }
}
