//-----------------------------------------------------------------------
// <copyright file=" ag_bodysource.cs">
// * FileName: 二次绩效保存数据.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 二次绩效保存数据
    /// </summary>
    [Table("ag_bodysource")]
    public class ag_bodysource
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int SecondId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> RowNumber { get; set; }

        /// <summary>
        /// 人员工号
        /// </summary>
        public string WorkNumber { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 岗位
        /// </summary>
        public string Post { get; set; }

        /// <summary>
        /// 人员系数
        /// </summary>
        public Nullable<decimal> StaffCoefficient { get; set; }

        /// <summary>
        /// 出勤
        /// </summary>
        public Nullable<decimal> ActualAttendance { get; set; }

        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 职称系数
        /// </summary>
        public Nullable<decimal> TitleCoefficient { get; set; }

        /// <summary>
        /// 职称绩效得分
        /// </summary>
        public Nullable<decimal> TitlePerformanceScore { get; set; }

        /// <summary>
        /// 职称绩效
        /// </summary>
        public Nullable<decimal> TitlePerformance { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> WorkPerformance { get; set; }

        ///// <summary>
        ///// 管理津贴
        ///// </summary>
        //public Nullable<decimal> ManagementAllowance { get; set; }

        ///// <summary>
        ///// 单项奖励
        ///// </summary>
        //public Nullable<decimal> IndividualReward { get; set; }

        ///// <summary>
        ///// 重点专科分配
        ///// </summary>
        //public Nullable<decimal> AllocationOfKeySpecialty { get; set; }

        /// <summary>
        /// 科室单项奖励
        /// </summary>
        public Nullable<decimal> DeptReward { get; set; }

        /// <summary>
        /// 科室考核前奖励
        /// </summary>
        public Nullable<decimal> PreDeptReward { get; set; }

        /// <summary>
        /// 主任基础绩效
        /// </summary>
        public Nullable<decimal> BasisPerformance { get; set; }

        /// <summary>
        /// 可分配绩效
        /// </summary>
        public Nullable<decimal> DistPerformance { get; set; }

        /// <summary>
        /// 医院其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerformance { get; set; }

        /// <summary>
        /// 夜班工作量绩效
        /// </summary>
        public Nullable<decimal> NightWorkPerformance { get; set; }

        /// <summary>
        /// 实发绩效(不含医院其他绩效)
        /// </summary>
        public Nullable<decimal> RealAmount { get; set; }

        /// <summary>
        /// 签字
        /// </summary>
        public string Signature { get; set; }

        /// <summary>
        /// 预留比例
        /// </summary>
        public Nullable<decimal> ReservedRatio { get; set; }

        /// <summary>
        /// 预留金额
        /// </summary>
        public Nullable<decimal> ReservedAmount { get; set; }

        /// <summary>
        /// 实发绩效(参考，含医院其他绩效)
        /// </summary>
        public Nullable<decimal> ReferToRealAmount { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
    }
}
