﻿using System.ComponentModel;


public enum AllotStates
{
    /// <summary> 数据未上传 </summary>
    [Description("数据未上传")]
    数据未上传 = 0,
    /// <summary> 数据已上传 </summary>
    [Description("数据已上传")]
    数据已上传 = 1,
    /// <summary> 正在校验数据 </summary>
    [Description("正在校验数据")]
    正在校验数据 = 2,
    /// <summary> 数据验证通过 </summary>
    [Description("数据验证通过")]
    数据验证通过 = 3,
    /// <summary> 数据错误 </summary>
    [Description("数据错误")]
    数据错误 = 4,
    /// <summary> 正在生成绩效 </summary>
    [Description("正在生成绩效")]
    正在生成绩效 = 5,
    /// <summary> 绩效下发 </summary>
    [Description("绩效下发")]
    绩效下发 = 6,
    /// <summary> 绩效解析失败 </summary>
    [Description("绩效解析失败")]
    绩效解析失败 = 7,
    /// <summary> 归档 </summary>
    [Description("归档")]
    归档 = 8,
    /// <summary> 等待 </summary>
    [Description("等待")]
    等待 = 9,
    /// <summary> 绩效结果解析成功 </summary>
    [Description("数据验证通过")]
    绩效结果解析成功 = 10,
}
public enum Role
{
    绩效管理员 = 1,
    医院管理员 = 2,
    护士长 = 3,
    科主任 = 4,
    绩效核算办 = 5,
    院领导 = 6,
    财务科 = 7,
    人事科 = 8,
    特殊科室 = 9,
    行政科室 = 10,
    数据收集 = 11,
    护理部审核 = 12,
    绩效查询 = 13,
    审计 = 14,
}
/// <summary> 核算单元类型 </summary>
public enum UnitType
{
    [Description("医生组")]
    医生组 = 1,

    [Description("护理组")]
    护理组 = 2,

    [Description("医技组")]
    医技组 = 3,

    //[Description("专家组")]
    //专家组 = 4,

    //[Description("其他")]
    //其他 = 5,
    [Description("特殊核算组")]
    特殊核算组 = 6,

    [Description("其他医生组")]
    其他医生组 = 7,

    [Description("其他护理组")]
    其他护理组 = 8,

    [Description("其他医技组")]
    其他医技组 = 9,

    [Description("行政高层")]
    行政高层 = 10,

    [Description("行政中层")]
    行政中层 = 11,

    [Description("行政工勤")]
    行政工勤 = 12,
}
