﻿using System.Collections.Generic;

namespace Performance.Services.OnlineExcel
{
    public class EpColumn
    {
        public int row { get; set; }
        public int col { get; set; }
        public string renderer { get; set; }
    }
    /// <summary>
    /// 单元格Class
    /// </summary>
    public class EpCellClass
    {
        private List<string> _className;
        public int row { get; set; }
        public int col { get; set; }
        public bool editor { get; set; }

        public string className
        {
            get
            {
                if (_className == null)
                    return "";
                return string.Join(" ", _className.ToArray());
            }
        }

        public void AddClassName(string name)
        {
            if (_className == null)
                _className = new List<string>();
            _className.Add(name);
        }
    }
}