﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 成本
    /// </summary>
    public class PerSheetDataReadExpend : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 4,
            HeaderLastRowNum = 4,
            HeaderFirstCellNum = 3,
            DataFirstRowNum = 5,
            DataFirstCellNum = 7,
            AccountingUnit = new List<AccountingUnit>
            {
                 new AccountingUnit
                 {
                     AccountingUnitCellNum = 3,
                     UnitType = "医技组",
                     DeptCellNum = 6,
                     FactorRow = 3,
                 },
                 new AccountingUnit
                 {
                     AccountingUnitCellNum = 4,
                     UnitType = "医生组",
                     DeptCellNum = 6,
                     FactorRow = 2,
                 },
                 new AccountingUnit
                 {
                     AccountingUnitCellNum = 5,
                     UnitType = "护理组",
                     DeptCellNum = 6,
                     FactorRow = 1,
                 },
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            //循环 当前有几个核算单元
            foreach (var unit in Point.AccountingUnit)
            {
                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);

                for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    if (row == null) continue;
                    for (int c = 0; c < vhead.Count(); c++)
                    {
                        var athead = vhead.ElementAt(c);

                        if (!string.IsNullOrEmpty(athead?.CellValue)
                            && Point.AccountingUnit.Any(t => athead.CellValue.Contains(t.UnitType))
                            && !athead.CellValue.Contains(unit.UnitType))
                            continue;
                        if (!string.IsNullOrEmpty(athead?.CellValue) && athead.CellValue.Contains("备注"))
                            continue;
                        //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                        var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                        if (!cellValue.HasValue || cellValue.Value == 0)
                            continue;

                        PerData data = new PerData
                        {
                            RowNumber = r,
                            SignID = athead.SignID,
                            AccountingUnit =  row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                            Department =  row.GetCell(unit.DeptCellNum.Value).GetValue(),
                            TypeName = athead?.CellValue,
                            CellValue = cellValue,
                            //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                            UnitType = unit.UnitType, //手动匹配   
                            FactorValue = ConvertHelper.ToDecimalOrNull(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell)?.NumericCellValue),
                            IsFactor = true,
                        };
                        var lastcell = vhead.OrderByDescending(t => t.PointCell).First();
                        if (lastcell.CellValue.Contains("备注"))
                            data.Remark = row.GetCell(lastcell.PointCell)?.StringCellValue;

                        if (string.IsNullOrEmpty(data.AccountingUnit) && string.IsNullOrEmpty(data.Department))
                            continue;
                        dataList.Add(data);
                    }
                }
            }
            return dataList;
        }
    }
}
