﻿using Microsoft.AspNetCore.Authorization;
using System.Threading.Tasks;
using System;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Performance.Services;
using Microsoft.Extensions.Configuration;

namespace Performance.Api.Controllers
{
    public class AppController : Controller
    {
        private readonly ILogger<AppController> _logger;
        private readonly IConfiguration _configuration;

        public AppController(ILogger<AppController> logger, IConfiguration configuration)
        {
            _logger = logger;
            _configuration = configuration;
        }

        [AllowAnonymous, HttpGet, Route("api/app/options")]
        public ActionResult AppOptions()
        {
            var OpenOAuth = _configuration.GetValue<bool>("AppOptions:OpenOAuth", false);
            return Ok(new ApiResponse(ResponseType.OK, "", new { OpenOAuth }));
        }
    }
}