﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class FixatItemRequest
    {
        public int AllotId { get; set; }

        public int SecondId { get; set; }

        public string UnitType { get; set; }

        public List<FixatItem> FixatItems { get; set; }

        public int RowNumber { get; set; }

    }

    public class FixatItemRequestValidator : AbstractValidator<FixatItemRequest>
    {
        public FixatItemRequestValidator()
        {
            RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
            RuleFor(x => x.SecondId).NotNull().GreaterThan(0);
            RuleFor(x => x.UnitType).NotNull().NotEmpty();
        }
    }

    public class FixatItem
    {
        public int FixatId { get; set; }

        public string ItemName { get; set; }

        public decimal ItemValue { get; set; }

        public decimal FactorValue { get; set; }

        public decimal Sort { get; set; }

        public int Type { get; set; }

        public int SourceType { get; set; }
    }
}
