﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class AssessSchemeDataResponse
    {
        /// <summary>
        /// 考核方案ID
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 绩效ID
        /// </summary>
        public int AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核类型编码
        /// </summary>
        public string AssessCode { get; set; }
        /// <summary>
        /// 考核类别名称
        /// </summary>
        public string AssessName { get; set; }
        /// <summary>
        /// 考核方案编码
        /// </summary>
        public string SchemeCode { get; set; }
        /// <summary>
        /// 考核方案名称
        /// </summary>
        public string SchemeName { get; set; }
        /// <summary>
        /// 考核方案备注
        /// </summary>
        public string SchemeRemarks { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
    }

    public class AssessSchemeTargetResponse
    {
        public int SchemeId { get; set; }
        /// <summary>
        /// 目标Id
        /// </summary>
        public int TargetId { get; set; }
        /// <summary>
        /// 核算单元编码
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 已设置方案
        /// </summary>
        public string SchemeName { get; set; }
        /// <summary>
        /// 状态  全部 = 0, 已设置其他方案= 1,未设置方案=2,已设置方案(不可勾选) = 3,
        /// </summary>
        public int SchemeState { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
    }
    public class AssessSchemeResultListResponse
    {
        /// <summary>
        /// 考核目标核算组别
        /// </summary>
        public string? TargetUnitType { get; set; }
        /// <summary>
        /// 考核目标核算单元
        /// </summary>
        public string? TargetAccountingUnit { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string? ItemName2 { get; set; }

        public List<AssessSchemeDictionaryResults> DictionaryResults { get; set; }
        public decimal? Score { get; set; }
        /// <summary>
        /// 合计
        /// </summary>
        public decimal? TotalAssessScore { get; set; }
    }
    public class AssessSchemeDictionaryResults
    {
        public decimal? Value { get; set; }
        public string Title { get; set; }

    }
    public class AssessSchemeEnterListResponse
    {
        /// <summary>
        /// 核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核类型编码
        /// </summary>
        public string AssessCode { get; set; }
        /// <summary>
        /// 考核类型
        /// </summary>
        public string AssessName { get; set; }
        /// <summary>
        /// 考核指标Id
        /// </summary>
        public int? ItemId { get; set; }
        /// <summary>
        /// 考核指标编码
        /// </summary>
        public string ItemCode { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public int State { get; set; }
        /// <summary>
        /// 提交时间
        /// </summary>
        public DateTime? SubmitTime { get; set; }
        /// <summary>
        /// 审核人
        /// </summary>
        public string? AuditBy { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditTime { get; set; }

        /// <summary>
        /// 总下发数
        /// </summary>
        public int Count { get; set; }
        /// <summary>
        /// 确认数
        /// </summary>
        public int ConfirmCount { get; set; }
        /// <summary>
        /// 驳回数
        /// </summary>
        public int RejectCount { get; set; }
        /// <summary>
        /// 待审核数
        /// </summary>
        public int AwaitCount { get; set; }
        /// <summary>
        /// 审核或驳回原因
        /// </summary>
        public string? AuditRemark { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
    }
    public class AssessSchemeEnterDetaiListResponse
    {
        /// <summary>
        /// 考核目标核算组别
        /// </summary>
        public string? TargetUnitType { get; set; }
        /// <summary>
        /// 考核目标核算单元
        /// </summary>
        public string? TargetAccountingUnit { get; set; }
        /// <summary>
        /// 下发Id
        /// </summary>
        public int? Id { get; set; }
        /// <summary>
        /// 考核指标Id
        /// </summary>
        public int? ItemId { get; set; }
        /// <summary>
        /// 指标编码
        /// </summary>
        public string? ItemCode { get; set; }
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string? ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string? ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核扣分
        /// </summary>
        public decimal? Score { get; set; }
        /// <summary>
        /// 扣分原因
        /// </summary>
        public string? ScoreRemark { get; set; }
        /// <summary>
        /// 状态  未提交 = 1,待审核 = 2,审核通过 = 3,驳回 = 4,
        /// </summary>
        public int State { get; set; }
        public int SchemeState { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 提交人
        /// </summary>
        public int? SubmitBy { get; set; }
        /// <summary>
        /// 提交时间
        /// </summary>
        public DateTime? SubmitTime { get; set; }
        /// <summary>
        /// 审核人
        /// </summary>
        public string? AuditBy { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditTime { get; set; }
        /// <summary>
        /// 审核或驳回原因
        /// </summary>
        public string? AuditRemark { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
    }
    //上传
    public class AssessSchemeItemsUploadResponse
    {
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
        /// <summary>
        /// 责任部门核算单元编码
        /// </summary>
        public string UnitCode { get; set; }
        /// <summary>
        /// 责任部门核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 责任部门核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        public int sort { get; set; }
        /// <summary>
        /// 指标编码
        /// </summary>
        public string ItemCode { get; set; }
        /// <summary>
        /// 操作类型 新增 = 1, 修改 = 2, 删除 = 3,
        /// </summary>
        public int OperationType { get; set; }
    }
}
