﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class UniteDeptDetailItem
    {
        /// <summary>
        /// ID 无实际意义，为前端提供
        /// </summary>
        public string Id { get; set; }
        /// <summary>
        /// ParentId 无实际意义，为前端提供
        /// </summary>
        public string ParentId { get; set; }
        /// <summary>
        /// 原始Sheet类型
        /// </summary>
        public int SheetType { get; set; }
        /// <summary>
        /// 显示标题
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 标题别名
        /// </summary>
        public string Alias { get; set; }
        /// <summary>
        /// 是否允许设置别名
        /// </summary>
        public bool IsAllowAlias { get; set; } = false;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 是否允许备注
        /// </summary>
        public bool IsAllowRemark { get; set; } = true;
        /// <summary>
        /// 格式
        /// </summary>
        public string Format { get; set; }
        /// <summary>
        /// 是否允许设置格式
        /// </summary>
        public bool IsAllowFormat { get; set; } = true;
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 是否显示
        /// </summary>
        public string Display { get; set; }
        /// <summary>
        /// 背景颜色突出
        /// </summary>
        public bool StandOut { get; set; } = false;
        /// <summary>
        /// 子集
        /// </summary>
        public List<UniteDeptDetailItem> Children { get; set; }
    }
}
