//-----------------------------------------------------------------------
// <copyright file=" per_assess_scheme.cs">
// * FileName: 考核方案.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 考核方案下发到责任科室指标清单
    /// </summary>
    [Table("per_assess_issue_scheme")]
    public class per_assess_issue_scheme
    {
        /// <summary>
        /// 考核方案下发到责任科室指标清单Id
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核类型编码
        /// </summary>
        public string AssessCode { get; set; }
        /// <summary>
        /// 考核类型名称
        /// </summary>
        public string AssessName { get; set; }
        /// <summary>
        /// 考核方案ID
        /// </summary>
        public int? SchemeId { get; set; }
        /// <summary>
        /// 考核方案编码
        /// </summary>
        public string SchemeCode { get; set; }
        /// <summary>
        /// 考核方案名称
        /// </summary>
        public string SchemeName { get; set; }
        /// <summary>
        /// 考核指标Id
        /// </summary>
        public int? ItemId { get; set; }
        /// <summary>
        /// 指标编码
        /// </summary>
        public string? ItemCode { get; set; }
        /// <summary>
        /// 一级指标名称
        /// </summary>
        public string ItemName1 { get; set; }
        /// <summary>
        /// 二级指标名称
        /// </summary>
        public string ItemName2 { get; set; }
        /// <summary>
        /// 考核分值
        /// </summary>
        public decimal AssessScore { get; set; }
        /// <summary>
        /// 考核标准
        /// </summary>
        public string AssessNorm { get; set; }
        /// <summary>
        /// 责任部门核算单元编码
        /// </summary>
        public string UnitCode { get; set; }
        /// <summary>
        /// 责任部门核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 责任部门核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
       public int State { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 考核扣分
        /// </summary>
        public decimal? Score { get; set; }
        /// <summary>
        /// 扣分原因
        /// </summary>
        public string? ScoreRemark { get; set; }
        /// <summary>
        /// 考核目标核算单元编码
        /// </summary>
        public string TargetUnitCode { get; set; }
        /// <summary>
        /// 考核目标核算组别
        /// </summary>
        public string TargetUnitType { get; set; }
        /// <summary>
        /// 考核目标核算单元
        /// </summary>
        public string TargetAccountingUnit { get; set; }
        /// <summary>
        /// 提交人
        /// </summary>
        public int? SubmitBy   { get; set; }
        /// <summary>
        /// 提交时间
        /// </summary>
        public DateTime? SubmitTime { get; set; }
        /// <summary>
        /// 审核人
        /// </summary>
        public string? AuditBy { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditTime { get; set; }
        /// <summary>
        /// 审核或驳回原因
        /// </summary>
        public string? AuditRemark { get; set; }
    }
}
