﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Globalization;
using System.Text;

namespace Performance.Infrastructure
{
    public static partial class UtilExtensions
    {
        public static DateTime ToTryDateTime(this string value, params string[] formats)
        {
            return string.IsNullOrEmpty(value) ? DateTime.MinValue : ToDateTime(value, formats);
        }

        public static DateTime ToDateTime(this string value, params string[] formats)
        {
            if (formats.Length == 0)
            {
                formats = new string[]
                {
                 "yyyyMMddHHmmss",
                 "yyyyMMddHHmmss",
                 "yyyy-MM-dd HH:mm:ss",
                 "yyyy年MM月dd日 HH时mm分ss秒" ,
                 "yyyyMdHHmmss",
                 "yyyy年M月d日 H时mm分ss秒",
                 "yyyy.M.d H:mm:ss",
                 "yyyy.MM.dd HH:mm:ss",
                 "yyyy-MM-dd",
                 "yyyyMMdd",
                 "yyyy/MM/dd",
                 "yyyy/M/d",
                 "yyyy-MM",
                 "yyyy/MM",
                 "yyyy/M",
                };
            }

            if (DateTime.TryParseExact(value, formats, CultureInfo.InvariantCulture, DateTimeStyles.None, out DateTime now))
                return now;

            return DateTime.MinValue;
        }
    }
}
