﻿using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Repository
{
    public partial class PerforAgsecondallotRepository : PerforRepository<ag_secondallot>
    {
        public IQueryable<ag_secondallot> GetSeconds(int[] hospitalIds, string[] unitType, string accountingUnit)
        {
            var secondallots = from ag in context.Set<ag_secondallot>()
                               join at in context.Set<per_allot>()
                               on ag.AllotId equals at.ID
                               where hospitalIds.Contains(at.HospitalId)
                               select ag;


            return secondallots
                  .Where(w => (unitType.Contains(w.UnitType) && w.Department == accountingUnit) || unitType.Contains(w.NewUnitType) && w.NewAccountingUnit == accountingUnit);
        }
        public IQueryable<ag_secondallot> Get(int allotId, string[] unitType, string accountingUnit, params int[] status)
        {
            var secondallots = from ag in context.Set<ag_secondallot>()
                               where ag.AllotId == allotId
                               select ag;


            secondallots = secondallots
                  .Where(w => (unitType.Contains(w.UnitType) && w.Department == accountingUnit) || unitType.Contains(w.NewUnitType) && w.NewAccountingUnit == accountingUnit);
            if (status.Any())
                return secondallots.Where(w => w.Status.HasValue && status.Contains(w.Status.Value));
            return secondallots;
        }

        /// <summary>
        /// 删除已提交的历史记录（ag_compute）
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public int DeleteComputeHistory(int secondId)
        {
            return Execute("DELETE FROM ag_compute WHERE SecondId = @secondId", new { secondId });
        }

        /// <summary>
        /// 查询二次分配结果 根据AllotId
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public List<view_second_compute_collect> GetComputeByAllot(int allotId)
        {
            var datas = DapperQuery<view_second_compute_collect>("SELECT * FROM view_second_compute_collect WHERE AllotId = @allotId", new { allotId });
            if (datas != null)
                return datas.ToList();

            return new List<view_second_compute_collect>();
        }
        /// <summary>
        /// 查询二次分配结果 根据SecondId
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public List<view_second_compute_collect> GetComputeBySecond(int secondId)
        {
            var datas = DapperQuery<view_second_compute_collect>("SELECT * FROM view_second_compute_collect WHERE SecondId = @secondId", new { secondId });
            if (datas != null)
                return datas.ToList();

            return new List<view_second_compute_collect>();
        }

        public int Submit(int secondId, int tempId, decimal realGiveFee, int submitType, string remark = "")
        {
            string sql = "UPDATE ag_secondallot SET UseTempId = @tempId,NursingDeptStatus = @status, Status = @status, SubmitType = @submitType,SubmitTime = @date, Remark = @remark WHERE Id = @secondId AND RealGiveFee = @fee";
            return Execute(sql, new { secondId, tempId, status = 2, date = DateTime.Now, fee = realGiveFee, submitType, remark });
        }
    }
}
