//-----------------------------------------------------------------------
// <copyright file=" per_budget_ratio.cs">
// * FileName: 预算管理占比.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 预算管理占比
    /// </summary>
    [Table("per_budget_ratio")]
	public class per_budget_ratio
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int Id { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public int HospitalId { get; set; }
    
        /// <summary>
        /// 根据该年份测算下一年
        /// </summary>
        public int MainYear { get; set; }
    
        /// <summary>
        /// 实际年份、预算年份
        /// </summary>
        public int Year { get; set; }
    
        /// <summary>
        /// 医院业务收入预算比例
        /// </summary>
        public Nullable<decimal> HospitalRevenue { get; set; }
    
        /// <summary>
        /// 人力总成本占比
        /// </summary>
        public Nullable<decimal> TotalLaborCost { get; set; }
    
        /// <summary>
        /// 人员支出固定部分占比
        /// </summary>
        public Nullable<decimal> StaffSpendingFixed { get; set; }
    
        /// <summary>
        /// 人员支出浮动部分占比
        /// </summary>
        public Nullable<decimal> StaffSpendingBonus { get; set; }
    
        /// <summary>
        /// 绩效工资增量预算比例
        /// </summary>
        public Nullable<decimal> MeritPayIncrement { get; set; }
    
        /// <summary>
        /// 绩效工资合计
        /// </summary>
        public Nullable<decimal> TotalMeritPay { get; set; }
    
        /// <summary>
        /// 增长幅度
        /// </summary>
        public Nullable<decimal> Amplification { get; set; }
    
        /// <summary>
        /// 增量后绩效工资人员经费比例
        /// </summary>
        public Nullable<decimal> IncrementCapitaRatio { get; set; }
    
        /// <summary>
        /// 药品收入占比
        /// </summary>
        public Nullable<decimal> TheDrugIncome { get; set; }
    
        /// <summary>
        /// 药品收入预算比例
        /// </summary>
        public Nullable<decimal> TheDrugIncomeBudget { get; set; }
    
        /// <summary>
        /// 材料支出占比
        /// </summary>
        public Nullable<decimal> MaterialIncome { get; set; }
    
        /// <summary>
        /// 材料支出预算比例
        /// </summary>
        public Nullable<decimal> MaterialIncomeBudget { get; set; }
    
        /// <summary>
        /// 药品+材料+人支占比
        /// </summary>
        public Nullable<decimal> TheCostInTotal { get; set; }
    
        /// <summary>
        /// 固定资产折旧费占比
        /// </summary>
        public Nullable<decimal> DepreOfFixedAssets { get; set; }
    
        /// <summary>
        /// 无形资产摊销费占比
        /// </summary>
        public Nullable<decimal> AmortOfIntangibleAssets { get; set; }
    
        /// <summary>
        /// 提取医疗风险基金占比
        /// </summary>
        public Nullable<decimal> MedicalRisk { get; set; }
    
        /// <summary>
        /// 其他费用占比
        /// </summary>
        public Nullable<decimal> OtherExpenses { get; set; }
    
        /// <summary>
        /// 收支结余（%）
        /// </summary>
        public Nullable<decimal> BalanceOfPayments { get; set; }
    
        /// <summary>
        /// 医院总收支结余
        /// </summary>
        public Nullable<decimal> TheTotalHospitalBalance { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateTime { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }
    }
}
