//-----------------------------------------------------------------------
// <copyright file=" rep_report.cs">
// * FileName: 报表配置表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 报表配置表
    /// </summary>
    [Table("rep_report")]
	public class rep_report
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> ChartType { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> Sort { get; set; }
    
        /// <summary>
        /// sql执行语句（{wh}及{w}为占位符）
        /// </summary>
        public string Content { get; set; }
    
        /// <summary>
        /// 报表标题
        /// </summary>
        public string Title { get; set; }
    
        /// <summary>
        /// 查询方法名称
        /// </summary>
        public string QueryName { get; set; }
    
        /// <summary>
        /// 查询参数
        /// </summary>
        public string QueryArguments { get; set; }
    
        /// <summary>
        /// X轴标题
        /// </summary>
        public string XTitle { get; set; }
    
        /// <summary>
        /// X轴单位
        /// </summary>
        public string XUnit { get; set; }
    
        /// <summary>
        /// Y轴标题
        /// </summary>
        public string YTitle { get; set; }
    
        /// <summary>
        /// Y轴单位
        /// </summary>
        public string YUnit { get; set; }
    
        /// <summary>
        /// 值标题
        /// </summary>
        public string VTitle { get; set; }
    
        /// <summary>
        /// 值单位
        /// </summary>
        public string VUnit { get; set; }
    
        /// <summary>
        /// name标题
        /// </summary>
        public string NTitle { get; set; }
    
        /// <summary>
        /// name单位
        /// </summary>
        public string NUnit { get; set; }
    
        /// <summary>
        /// 图表说明
        /// </summary>
        public string Formula { get; set; }
    
        /// <summary>
        /// 1表示需要进行小于百分2的类型进行合并
        /// </summary>
        public Nullable<int> DataType { get; set; }
    
        /// <summary>
        /// 图标value过滤执值
        /// </summary>
        public Nullable<decimal> FilterValue { get; set; }
    }
}
