﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Repository
{
    public partial class PerforLogdbugRepository
    {
        /// <summary>
        /// 绩效生成专用
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="title"></param>
        /// <param name="message"></param>
        /// <returns></returns>
        public bool Add(int allotId, string title, string message, int level, int type)
        {
            return Add(new EntityModels.log_dbug { AllotID = allotId, CreateTime = DateTime.Now, Title = title, Message = message, Level = level, Type = type });
        }


        public bool ClearExtractLog(int allotId)
        {
            var entities = GetEntities(t => t.AllotID == allotId && new int[] { 2, 3 }.Contains(t.Type.Value));
            if (entities != null && entities.Any())
                return RemoveRange(entities.ToArray());

            return true;
        }
    }
}
