﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services.ExtractExcelService.SheetDataWrite
{
    public interface ISheetDataWrite
    {
        /// <summary>
        /// 写入采集数据
        /// </summary>
        /// <param name="sheet">ISheet</param>
        /// <param name="point">数据起始字典</param>
        /// <param name="sheetType"></param>
        /// <param name="style"></param>
        /// <param name="collects">采集数据</param>
        void WriteCollectData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, List<collect_data> collects, Dictionary<ExDataDict, object> exdict = null);

        /// <summary>
        /// 写入抽取数据
        /// </summary>
        /// <param name="sheet">ISheet</param>
        /// <param name="point">数据起始字典</param>
        /// <param name="sheetType"></param>
        /// <param name="style"></param>
        /// <param name="data">抽取数据</param>
        /// <param name="exdict">配置字典</param>
        void WriteSheetData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, object data, Dictionary<ExDataDict, object> exdict = null);
    }
}
