﻿    using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace Performance.Infrastructure
{
    public class HuyiSmsConfig
    {
        public string Url { get; set; }
        public string Account { get; set; }
        public string Password { get; set; }
    }

    public class HuyiSmsNotify
    {
        private HuyiSmsConfig _config;
        private readonly ILogger<HuyiSmsNotify> _logger;
        public HuyiSmsNotify(IOptions<HuyiSmsConfig> config, ILoggerFactory factory)
        {
            this._logger = factory.CreateLogger<HuyiSmsNotify>();
            _config = config.Value;
        }
        public HuyiResponse SendSms(string mobile, string content)
        {
            var cfg = _config;
            string postBody = $"account={cfg.Account}&password={cfg.Password}&mobile={mobile}&content={content}";
            UTF8Encoding encoding = new UTF8Encoding();
            byte[] postData = encoding.GetBytes(postBody);
            var response = HttpHelper.HttpPost(cfg.Url, postBody, false);
            _logger.LogInformation(response);
            var serializer = new XMLSerializer();
            return serializer.Deserialize<HuyiResponse>(response);
        }
    }

    [XmlRoot(ElementName = "SubmitResult", Namespace = "http://106.ihuyi.cn/")]
    public class HuyiResponse
    {
        [XmlElement("code")]
        public string code { get; set; }
        [XmlElement("msg")]
        public string msg { get; set; }
        [XmlElement("smsid")]
        public string smsid { get; set; }
    }

}
