﻿using AutoMapper;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.DtoModels.AutoMapper;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.IO;

namespace Performance.ConsoleApp
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine($"{(21555 / 1000.0).ToString("f2")}");


            Console.WriteLine("Hello World!");

            var builder = new ConfigurationBuilder()
                  .SetBasePath(AppDomain.CurrentDomain.BaseDirectory)
                  .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                  .AddJsonFile("appsettings.Development.json", optional: true, reloadOnChange: true);
            IConfigurationRoot configuration = builder.Build();

            ServiceCollection services = new ServiceCollection();
            services.AddLogging();
            //serviceProvider.GetService<ILoggerFactory>().AddConsole();


            services.Configure<EmailOptions>(configuration.GetSection("EmailOptions"));

            var option = services.BuildServiceProvider().GetService<IOptions<EmailOptions>>();

            services.AddEmailUtil(config => { config.Account = option.Value.Account; config.Password = option.Value.Password; config.SmtpServer = option.Value.SmtpServer; });
            var emailService = services.BuildServiceProvider().GetService<IEmailService>();
            var message = new EmailMessage
            {
                To = new List<string> { "ruyun.zhang@suvalue.com", "huiliang.wang@suvalue.com" },
                Attachments = new List<string> { @"E:\code_git\performance\performance\Performance.Api\Files\9\201911\医院绩效分配系统数据收集模板V120190307133444707.xlsx" },
                DisplayName = "溯直健康",
                Subject = "测试",
                Body = "我是测试"
            };
            emailService.Send(message);
            var task = emailService.SendAsync(message);
            task.Wait();

            Mapper.Initialize(cfg => cfg.AddProfile<AutoMapperConfigs>());
            services.AddAutoMapper();

            //service注入 repoitory注入 
            services
                .AddPerformanceService()
                .AddPerformanceRepoitory();

            var connection = configuration.GetSection("AppConnection:PerformanceConnectionString").Value;

            services.AddDbContext<PerformanceDbContext>(options =>
            {
                options.UseMySQL(connection);
            });

            Console.ReadKey();
        }
    }
}
