﻿using AutoMapper;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels.AutoMapper
{
    public class AutoMapperConfigs : Profile
    {
        public AutoMapperConfigs()
        {
            //用户登录信息
            CreateMap<UserIdentity, sys_user>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.UserID));
            CreateMap<sys_user, UserIdentity>()
                .ForMember(dest => dest.UserID, opt => opt.MapFrom(src => src.ID));

            //用户 响应
            CreateMap<UserResponse, sys_user>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.UserID));
            CreateMap<sys_user, UserResponse>()
                .ForMember(dest => dest.UserID, opt => opt.MapFrom(src => src.ID));

            //用户新增/修改 请求
            CreateMap<UserRequest, sys_user>();
            CreateMap<sys_user, UserRequest>();

            // 用户医院列表 响应
            CreateMap<HospitalResponse, sys_hospital>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.HosID));
            CreateMap<sys_hospital, HospitalResponse>()
                .ForMember(dest => dest.HosID, opt => opt.MapFrom(src => src.ID));

            // 医院新增/修改 请求
            CreateMap<HospitalRequest, sys_hospital>();
            CreateMap<sys_hospital, HospitalRequest>();

            // 角色 响应
            CreateMap<RoleResponse, sys_role>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.RoleID));
            CreateMap<sys_role, RoleResponse>()
                .ForMember(dest => dest.RoleID, opt => opt.MapFrom(src => src.ID));

            // 菜单 响应
            CreateMap<MenuResponse, sys_menu>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.MenuID));
            CreateMap<sys_menu, MenuResponse>()
                .ForMember(dest => dest.MenuID, opt => opt.MapFrom(src => src.ID));

            // 绩效 请求
            CreateMap<AllotRequest, per_allot>();
            CreateMap<per_allot, AllotRequest>();

            // 绩效 响应
            CreateMap<AllotResponse, per_allot>();
            CreateMap<per_allot, AllotResponse>();


            // sheet 响应
            CreateMap<SheetResponse, per_sheet>()
                 .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.SheetID));
            CreateMap<per_sheet, SheetResponse>()
                .ForMember(dest => dest.SheetID, opt => opt.MapFrom(src => src.ID));

            CreateMap<PerHeader, im_header>()
                .ForMember(dest => dest.IsMerge, opt => opt.MapFrom(src => src.IsMerge ? 1 : 2));
            CreateMap<PerData, im_data>()
                .ForMember(dest => dest.IsFactor, opt => opt.MapFrom(src => src.IsFactor ? 1 : 2))
                .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => src.UnitType == "医生组" ? 1 : (src.UnitType == "护理组" ? 2 : 0)));

            CreateMap<PerDataEmployee, im_employee>();

            CreateMap<PerDataAccountBaisc, PerDataAccountDoctor>()
                .ForMember(dest => dest.AccountingUnit, opt => opt.MapFrom(src => src.AccountingUnit))
                .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
                .ForMember(dest => dest.Number, opt => opt.MapFrom(src => src.DoctorNumber))
                .ForMember(dest => dest.BasicFactor, opt => opt.MapFrom(src => src.DoctorBasicFactor))
                .ForMember(dest => dest.SlopeFactor, opt => opt.MapFrom(src => src.DoctorSlopeFactor))
                .ForMember(dest => dest.OtherPerfor1, opt => opt.MapFrom(src => src.DoctorOtherPerfor1))
                .ForMember(dest => dest.OtherPerfor2, opt => opt.MapFrom(src => src.DoctorOtherPerfor2))
                .ForMember(dest => dest.Extra, opt => opt.MapFrom(src => src.DoctorExtra))
                .ForMember(dest => dest.ScoringAverage, opt => opt.MapFrom(src => src.DoctorScoringAverage))
                .ForMember(dest => dest.AdjustFactor, opt => opt.MapFrom(src => src.DoctorAdjustFactor));

            CreateMap<PerDataAccountBaisc, PerDataAccountNurse>()
                .ForMember(dest => dest.AccountingUnit, opt => opt.MapFrom(src => src.AccountingUnit))
                .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
                .ForMember(dest => dest.Number, opt => opt.MapFrom(src => src.NurseNumber))
                .ForMember(dest => dest.BasicFactor, opt => opt.MapFrom(src => src.NurseBasicFactor))
                .ForMember(dest => dest.SlopeFactor, opt => opt.MapFrom(src => src.NurseSlopeFactor))
                .ForMember(dest => dest.OtherPerfor1, opt => opt.MapFrom(src => src.NurseOtherPerfor1))
                .ForMember(dest => dest.OtherPerfor2, opt => opt.MapFrom(src => src.NurseOtherPerfor2))
                .ForMember(dest => dest.Extra, opt => opt.MapFrom(src => src.NurseExtra))
                .ForMember(dest => dest.ScoringAverage, opt => opt.MapFrom(src => src.NurseScoringAverage))
                .ForMember(dest => dest.AdjustFactor, opt => opt.MapFrom(src => src.NurseAdjustFactor));

            CreateMap<PerDataAccountBaisc, im_accountbasic>();
            CreateMap<PerDataSpecialUnit, im_specialunit>();
            CreateMap<PerDataAccountDoctor, res_accountdoctor>();
            CreateMap<res_accountdoctor, PerDataAccount>();
            CreateMap<PerDataAccountNurse, res_accountnurse>();
            CreateMap<res_accountnurse, PerDataAccount>();

            CreateMap<res_accountdoctor, ComputeSource>();
            CreateMap<res_accountnurse, ComputeSource>();
            CreateMap<im_employee, ComputeEmployee>();
            CreateMap<ComputeResult, res_compute>();

            CreateMap<res_accountdoctor, DoctorResponse>();
            CreateMap<res_accountnurse, NurseResponse>();


            //二次绩效
            CreateMap<ag_header, PerHeader>();
            CreateMap<PerHeader, ag_header>();

            CreateMap<PerAgainData, ag_data>();
            CreateMap<ag_data, PerAgainData>();

            CreateMap<PerAgainEmployee, ag_employee>();
            CreateMap<ag_employee, PerAgainEmployee>();

            CreateMap<PerAgainSituation, ag_againsituation>();
            CreateMap<ag_againsituation, PerAgainSituation>();

            CreateMap<per_againallot, AgainAllotResponse>();
            CreateMap<res_compute, ComputeResponse>();
        }
    }
}
