﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Performance.DtoModels
{
    public enum ExcelVersion
    {
        xlsx,
        xls
    }

    public enum SheetType
    {
        /// <summary> 无法识别 </summary>
        [Description("无法识别")]
        Unidentifiable = 1,
        /// <summary> 医院人员名单 </summary>
        [Description("医院人员名单")]
        Employee = 2,
        /// <summary> 收入 </summary>
        [Description("收入")]
        Income = 3,
        /// <summary> 其他收入 </summary>
        [Description("其他收入")]
        OtherIncome = 4,
        /// <summary> 支出 </summary>
        [Description("支出")]
        Expend = 5,
        /// <summary> 加班 </summary>
        [Description("加班")]
        Overtime = 6,
        /// <summary> 工作量 </summary>
        [Description("工作量")]
        Workload = 7,
        /// <summary> 特殊核算单元 </summary>
        [Description("特殊核算单元")]
        SpecialUnit = 8,
        /// <summary> 临床科室医护绩效测算基础 </summary>
        [Description("临床科室医护绩效测算基础")]
        AccountBasic = 9,

        /// <summary> 科室经济核算汇总表 </summary>
        [Description("科室经济核算汇总表")]
        ComputeEconomic = 10,
        /// <summary> 医生工作量计算 </summary>
        [Description("医生工作量计算")]
        ComputeDoctorWorkload = 11,
        /// <summary> 护士工作量计算 </summary>
        [Description("护士工作量计算")]
        ComputeNurseWorkload = 12,
        /// <summary> 临床科室医生绩效测算表 </summary>
        [Description("临床科室医生绩效测算表")]
        ComputeDoctorAccount = 13,
        /// <summary> 临床科室护士绩效测算表 </summary>
        [Description("临床科室护士绩效测算表")]
        ComputeNurseAccount = 14,
    }

    /// <summary>
    /// 绩效类型 
    /// </summary>
    public enum PerformanceType
    {
        /// <summary>  </summary>
        [Description("")]
        Null = 0,

        /// <summary> 科室主任人均绩效 </summary>
        [Description("科室主任人均绩效")]
        Director = 1,
        /// <summary> 科室副主任人均绩效 </summary>
        [Description("科室副主任人均绩效")]
        DeputyDirector = 2,
        /// <summary> 科室护士长人均绩效 </summary>
        [Description("科室护士长人均绩效")]
        Nurse = 3,

        /// <summary> 临床科室主任人均绩效 (绩效标准取 科室主任人均绩效) </summary>
        [Description("临床科室主任人均绩效")]
        ReferenceDirector = 4,
        /// <summary> 临床科室中层人均绩效 (绩效标准取 科室主任/护士长/科室副主任/医技主任 平均值) </summary>
        [Description("临床科室中层人均绩效")]
        ReferenceDirectorAvg = 5,
        /// <summary> 临床科室护士人均绩效的95% (绩效标准取 护理组临床科室单元核算表 平均值) </summary>
        [Description("临床科室护士人均绩效的95%")]
        ReferenceNurseAvg95 = 6,
        /// <summary> 临床科室护士长人均绩效 (绩效标准取 护士长 平均值)</summary>
        [Description("临床科室护士长人均绩效")]
        ReferenceHeadNurse = 7,
    }
}
