﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class DirectorRequest : ApiRequest
    {
        public int ID { get; set; }
        
        public int AllotID { get; set; }
        /// <summary>
        /// 绩效类型
        /// </summary>
        public string TypeName { get; set; }
        /// <summary>
        /// 职务名称
        /// </summary>
        public string JobTitle { get; set; }
        /// <summary>
        /// 绩效系数
        /// </summary>
        public decimal Value { get; set; }


        public class DirectorRequestValidator : AbstractValidator<DirectorRequest>
        {
            public DirectorRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
