﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// 登录请求
    /// </summary>
    public class HospitalRequest : ApiRequest
    {
        public int ID { get; set; }
        /// <summary>
        /// 医院名称
        /// </summary>
        public string HosName { get; set; }
        /// <summary>
        /// 简称
        /// </summary>
        public string ShortName { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string AreaCode { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string HosLevel { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string HosType { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> States { get; set; }
    }

    public class HospitalRequestValidator : AbstractValidator<HospitalRequest>
    {
        public HospitalRequestValidator()
        {
            Action action = () =>
            {
                RuleFor(x => x.HosName).NotNull().NotEmpty().Length(1, 50);
                RuleFor(x => x.AreaCode).NotNull().NotEmpty().Length(1, 50);
                RuleFor(x => x.HosLevel).NotNull().NotEmpty().Length(1, 50);
                RuleFor(x => x.HosType).NotNull().NotEmpty().Length(1, 50);
            };

            RuleSet("Insert", () =>
            {
                action();
            });

            RuleSet("Update", () =>
            {
                action();
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
                RuleFor(x => x.States).NotNull().InclusiveBetween(1, 2);
            });

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
            });

            RuleSet("Disable", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
                RuleFor(x => x.States).NotNull().InclusiveBetween(1, 2);
            });
        }
    }
}
