﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{

    public class WorkyearRequest : ApiRequest
    {
        public int ID { get; set; }

        public int AllotID { get; set; }
        /// <summary>
        /// 最大工龄范围（小于）
        /// </summary>
        public decimal MaxRange { get; set; }
        /// <summary>
        /// 最小工龄范围（大于等于）
        /// </summary>
        public decimal MinRange { get; set; }
        /// <summary>
        /// 绩效系数
        /// </summary>
        public decimal Value { get; set; }


        public class WorkyearRequestValidator : AbstractValidator<WorkyearRequest>
        {
            public WorkyearRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
