
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using System;

namespace Performance.EntityModels
{
    public partial class PerformanceDbContext : DbContext
    {
        public PerformanceDbContext(DbContextOptions<PerformanceDbContext> options)
            : base(options)
        {
        }

		/// <summary> 二次分配概览 <summary>
        public virtual DbSet<ag_againsituation> ag_againsituation { get; set; }
		/// <summary> 二次分配不固定数据 <summary>
        public virtual DbSet<ag_data> ag_data { get; set; }
		/// <summary> 二次分配人员名单 <summary>
        public virtual DbSet<ag_employee> ag_employee { get; set; }
		/// <summary> 二次分配不固定列头数据 <summary>
        public virtual DbSet<ag_header> ag_header { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<cof_again> cof_again { get; set; }
		/// <summary> 规模绩效、效率绩效计算系数配置 <summary>
        public virtual DbSet<cof_director> cof_director { get; set; }
		/// <summary> 工作量门诊药占比系数 <summary>
        public virtual DbSet<cof_drugprop> cof_drugprop { get; set; }
		/// <summary> ICU医生护士有效收入汇总计算系数 <summary>
        public virtual DbSet<cof_income> cof_income { get; set; }
		/// <summary> 工龄对应绩效系数配置 <summary>
        public virtual DbSet<cof_workyear> cof_workyear { get; set; }
		/// <summary> 科室核算导入信息 <summary>
        public virtual DbSet<im_accountbasic> im_accountbasic { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<im_data> im_data { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<im_employee> im_employee { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<im_header> im_header { get; set; }
		/// <summary> 特殊科室核算 <summary>
        public virtual DbSet<im_specialunit> im_specialunit { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<log_dbug> log_dbug { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<per_againallot> per_againallot { get; set; }
		/// <summary> 医院绩效分配 <summary>
        public virtual DbSet<per_allot> per_allot { get; set; }
		/// <summary> 上传数据解析 <summary>
        public virtual DbSet<per_sheet> per_sheet { get; set; }
		/// <summary> 医生科室核算结果 <summary>
        public virtual DbSet<res_accountdoctor> res_accountdoctor { get; set; }
		/// <summary> 护理科室核算结果 <summary>
        public virtual DbSet<res_accountnurse> res_accountnurse { get; set; }
		/// <summary> 核算基础标准 <summary>
        public virtual DbSet<res_baiscnorm> res_baiscnorm { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<res_compute> res_compute { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<res_specialunit> res_specialunit { get; set; }
		/// <summary> 医院信息 <summary>
        public virtual DbSet<sys_hospital> sys_hospital { get; set; }
		/// <summary> 菜单表 <summary>
        public virtual DbSet<sys_menu> sys_menu { get; set; }
		/// <summary> 角色表 <summary>
        public virtual DbSet<sys_role> sys_role { get; set; }
		/// <summary> 角色菜单关联表 <summary>
        public virtual DbSet<sys_role_menu> sys_role_menu { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<sys_sms> sys_sms { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<sys_user> sys_user { get; set; }
		/// <summary>  <summary>
        public virtual DbSet<sys_user_hospital> sys_user_hospital { get; set; }
		/// <summary> 用户角色关联表 <summary>
        public virtual DbSet<sys_user_role> sys_user_role { get; set; }
    }
}
