//-----------------------------------------------------------------------
// <copyright file=" sys_hospital.cs">
// * FileName: 医院信息.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 医院信息
    /// </summary>
    [Table("sys_hospital")]
	public class sys_hospital
    {
        /// <summary>
        /// ID
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }
    
        /// <summary>
        /// 医院名称
        /// </summary>
        public string HosName { get; set; }
    
        /// <summary>
        /// 简称
        /// </summary>
        public string ShortName { get; set; }
    
        /// <summary>
        /// 医院区域编码
        /// </summary>
        public string AreaCode { get; set; }
    
        /// <summary>
        /// 医院等级
        /// </summary>
        public string HosLevel { get; set; }
    
        /// <summary>
        /// 医院类型
        /// </summary>
        public string HosType { get; set; }
    
        /// <summary>
        /// 医院状态 1 启用 2 禁用
        /// </summary>
        public Nullable<int> States { get; set; }
    }
}
