﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.AllotCompute
{
    /// <summary>
    /// 最终绩效计算
    /// </summary>
    public class ResultComputeService : IAutoInjection
    {
        private ComputeDirector computeDirector;
        private PerforImemployeeRepository perforImEmployeeRepository;
        private PerforCofworkyearRepository perforCofworkyearRepository;
        private PerforCofdirectorRepository perforCofdirectorRepository;
        private PerforResaccountdoctorRepository perforResAccountdoctorRepository;
        private PerforResaccountnurseRepository perforResAccountnurseRepository;
        private PerforRescomputeRepository perforRescomputeRepository;
        private PerforResbaiscnormRepository perforResbaiscnormRepository;
        private PerforResspecialunitRepository perforResspecialunitRepository;
        public ResultComputeService(
            PerforImemployeeRepository perforImEmployeeRepository,
            PerforCofworkyearRepository perforCofworkyearRepository,
            PerforCofdirectorRepository perforCofdirectorRepository,
            PerforResaccountdoctorRepository perforResAccountdoctorRepository,
            PerforResaccountnurseRepository perforResAccountnurseRepository,
            PerforRescomputeRepository perforRescomputeRepository,
            PerforResbaiscnormRepository perforResbaiscnormRepository,
            PerforResspecialunitRepository perforResspecialunitRepository,
            ComputeDirector computeDirector)
        {
            this.computeDirector = computeDirector;
            this.perforImEmployeeRepository = perforImEmployeeRepository;
            this.perforCofworkyearRepository = perforCofworkyearRepository;
            this.perforCofdirectorRepository = perforCofdirectorRepository;
            this.perforResAccountdoctorRepository = perforResAccountdoctorRepository;
            this.perforResAccountnurseRepository = perforResAccountnurseRepository;
            this.perforRescomputeRepository = perforRescomputeRepository;
            this.perforResbaiscnormRepository = perforResbaiscnormRepository;
            this.perforResspecialunitRepository = perforResspecialunitRepository;
        }

        /// <summary>
        /// 计算最终数据
        /// </summary>
        /// <param name="excel"></param>
        public List<res_baiscnorm> Compute(per_allot allot, PerExcel excel, res_baiscnorm baiscnorm)
        {
            //取出人员信息           
            var empolyeeList = perforImEmployeeRepository.GetEntities(t => t.AllotID == allot.ID);
            //年资系数
            var workyearList = perforCofworkyearRepository.GetEntities(t => t.AllotID == allot.ID);
            //规模绩效和效率绩效配置表
            var directorList = perforCofdirectorRepository.GetEntities(t => t.AllotID == allot.ID);
            //取出医生科室
            var doctorList = perforResAccountdoctorRepository.GetEntities(t => t.AllotID == allot.ID);
            //取出护士科室
            var nurseList = perforResAccountnurseRepository.GetEntities(t => t.AllotID == allot.ID);

            List<ComputeEmployee> computeEmployees = Mapper.Map<List<ComputeEmployee>>(empolyeeList);

            List<ComputeSource> computeSources = new List<ComputeSource>();
            computeSources.AddRange(Mapper.Map<List<ComputeSource>>(doctorList));
            computeSources.AddRange(Mapper.Map<List<ComputeSource>>(nurseList));

            var computResult = computeDirector.Compute(computeEmployees, computeSources, directorList);
            var baiscnormList = computeDirector.ComputeAvg(computResult);
            baiscnormList.Add(baiscnorm);

            var computResult2 = computeDirector.Compute(computeEmployees, baiscnormList, workyearList);


            var computes = Mapper.Map<List<res_compute>>(computResult);
            computes.AddRange(Mapper.Map<List<res_compute>>(computResult2));
            computes.ForEach(t => t.AllotID = allot.ID);
            perforRescomputeRepository.AddRange(computes.ToArray());

            baiscnormList.ForEach(t => t.AllotID = allot.ID);
            perforResbaiscnormRepository.AddRange(baiscnormList.ToArray());

            return baiscnormList;
        }


        /// <summary>
        /// 特殊科室绩效计算
        /// </summary>
        /// <param name="excel"></param>
        /// <param name="allot"></param>
        public void SpecialUnitCompute(PerExcel excel, per_allot allot, List<res_baiscnorm> baiscnormList)
        {
            var specialUnit = excel.PerSheet.FirstOrDefault(t => t.SheetType == SheetType.SpecialUnit);
            if (specialUnit == null || specialUnit.PerData.Count == 0)
                return;
            var dataList = specialUnit.PerData.Select(t => (PerDataSpecialUnit)t);
            BaiscNormService baiscNormService = new BaiscNormService();

            var typeList = EnumHelper.GetItems<PerformanceType>();
            List<res_specialunit> resDataList = new List<res_specialunit>();
            foreach (var t in dataList)
            {
                var type = typeList.FirstOrDefault(o => o.Description == t.QuantitativeIndicators);
                if (type != null)
                    t.Quantity = baiscNormService.GetBaiscNorm(baiscnormList, (PerformanceType)type.Value);

                var res = new res_specialunit
                {
                    AllotID = allot.ID,
                    AccountingUnit = t.AccountingUnit,
                    Department = t.AccountingUnit,
                    Number = t.Number,
                    QuantitativeIndicators = t.QuantitativeIndicators,
                    Quantity = t.Quantity,
                    QuantitativeIndicatorsValue = t.QuantitativeIndicatorsValue,
                    ScoringAverage = t.ScoringAverage,
                    OtherPerfor = t.OtherPerfor,
                    Punishment = t.Punishment,
                    Adjust = t.Adjust,
                    Avg = t.Quantity * t.QuantitativeIndicatorsValue / t.Number,
                    GiveFee = t.Quantity * t.QuantitativeIndicatorsValue,
                    RealGiveFee = (t.Quantity * t.QuantitativeIndicatorsValue + t.OtherPerfor + t.Punishment) * t.Adjust,
                };
                resDataList.Add(res);
            }
            perforResspecialunitRepository.AddRange(resDataList.ToArray());
        }
    }
}
