﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class ComputeService : IAutoInjection
    {
        private PerforResaccountdoctorRepository _perforResAccountdoctorRepository;
        private PerforResaccountnurseRepository _perforResAccountnurseRepository;
        private PerforPersheetRepository _perforPerSheetRepository;
        private PerforImdataRepository _perforImDataRepository;
        private PerforRescomputeRepository _perforRescomputeRepository;
        private PerforResspecialunitRepository _perforResspecialunitRepository;
        private PerforPeragainallotRepository _perforPeragainallotRepository;
        private PerforUserRepository _perforUserRepository;
        private PerforAgemployeeRepository _perforAgemployeeRepository;
        public ComputeService(PerforResaccountdoctorRepository perforResAccountdoctorRepository,
            PerforResaccountnurseRepository perforResAccountnurseRepository,
            PerforPersheetRepository perforPerSheetRepository,
            PerforImdataRepository perforImDataRepository,
            PerforRescomputeRepository perforRescomputeRepository,
            PerforResspecialunitRepository perforResspecialunitRepository,
            PerforPeragainallotRepository perforPeragainallotRepository,
            PerforUserRepository perforUserRepository,
            PerforAgemployeeRepository perforAgemployeeRepository)
        {
            _perforResAccountdoctorRepository = perforResAccountdoctorRepository;
            _perforResAccountnurseRepository = perforResAccountnurseRepository;
            _perforPerSheetRepository = perforPerSheetRepository;
            _perforImDataRepository = perforImDataRepository;
            _perforRescomputeRepository = perforRescomputeRepository;
            _perforResspecialunitRepository = perforResspecialunitRepository;
            _perforPeragainallotRepository = perforPeragainallotRepository;
            _perforUserRepository = perforUserRepository;
            _perforAgemployeeRepository = perforAgemployeeRepository;
        }

        /// <summary>
        /// 返回绩效发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <param name="type">绩效基数核算参考对象</param>
        /// <returns></returns>
        public List<res_compute> GetCompute(int allotId, int type)
        {
            var list = new List<res_compute>();
            Dictionary<int, List<PerformanceType>> keyValues = new Dictionary<int, List<PerformanceType>>
            {
                { 1,new List<PerformanceType>{ PerformanceType.ReferenceDirector } },
                { 2,new List<PerformanceType>{ PerformanceType.ReferenceDirectorAvg } },
                { 3,new List<PerformanceType>{ PerformanceType.ReferenceNurseAvg95, PerformanceType.ReferenceHeadNurse, PerformanceType.Null } },
                { 4,new List<PerformanceType>{ PerformanceType.Director, PerformanceType.DeputyDirector } },
                { 5,new List<PerformanceType>{ PerformanceType.Nurse } }
            };

            if (keyValues.ContainsKey(type))
            {
                var conList = keyValues[type].Select(t => EnumHelper.GetDescription(t));
                list = _perforRescomputeRepository.GetEntities(t => t.AllotID == allotId && conList.Contains(t.FitPeople))
                       .OrderBy(t => t.AccountingUnit).ThenBy(t => t.FitPeople).ToList();
            }
            else
            {
                throw new PerformanceException("参数错误，type无效");
            }
            return Mapper.Map<List<res_compute>>(list);
        }

        /// <summary>
        /// 返回特殊科室发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<res_specialunit> GetSpecial(int allotId)
        {
            var list = _perforResspecialunitRepository.GetEntities(t => t.AllotID == allotId);
            return Mapper.Map<List<res_specialunit>>(list);
        }

        /// <summary>
        /// 返回医生组科室绩效
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<DoctorResponse> GetDoctorPerformance(int allotId)
        {
            var list = _perforResAccountdoctorRepository.GetEntities(t => t.AllotID == allotId);
            List<DoctorResponse> doctor = Mapper.Map<List<DoctorResponse>>(list);
            doctor?.ForEach(t => t.UnitName = "医生组");
            return doctor;
        }

        /// <summary>
        /// 返回护理组科室绩效
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<NurseResponse> GetNursePerformance(int allotId)
        {
            var list = _perforResAccountnurseRepository.GetEntities(t => t.AllotID == allotId);
            List<NurseResponse> nurse = Mapper.Map<List<NurseResponse>>(list);
            nurse?.ForEach(t => t.UnitName = "护理组");
            return nurse;
        }

        /// <summary>
        /// 查看科室绩效
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="department"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public DeptDetailResponse GetDepartmentDetail(int allotId, string department, int type)
        {
            if (type == 1)
            {
                var accountList = _perforResAccountdoctorRepository.GetEntities(t => t.AllotID == allotId && t.AccountingUnit == department);
                if (accountList != null)
                    return GetDepartmentDetail(allotId, accountList.First().ID, type);
            }
            else if (type == 2)
            {
                var accountList = _perforResAccountnurseRepository.GetEntities(t => t.AllotID == allotId && t.AccountingUnit == department);
                if (accountList != null)
                    return GetDepartmentDetail(allotId, accountList.First().ID, type);
            }
            return null;
        }


        /// <summary>
        /// 返回科室详情
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="accountId"></param>
        /// <param name="type"> 1 医生组 2 护理组</param>
        /// <returns></returns>
        public DeptDetailResponse GetDepartmentDetail(int allotId, int accountId, int type)
        {
            var sheetList = _perforPerSheetRepository.GetEntities(t => t.AllotID == allotId);
            if (type == 1)
            {
                var doctor = _perforResAccountdoctorRepository.GetEntity(t => t.AllotID == allotId && t.ID == accountId);

                DeptDetailResponse response = new DeptDetailResponse()
                {
                    Pandect = Mapper.Map<PerDataAccount>(doctor),
                    Economic = new List<DeptDetail>(),
                    Workload = new List<DeptDetail>()
                };

                var sheetWorkload = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeDoctorWorkload);
                if (sheetWorkload == null)
                    return null;
                var dataWorkloadList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetWorkload.ID && t.IsTotal != 1 && t.AccountingUnit == doctor.AccountingUnit);
                if (dataWorkloadList != null && dataWorkloadList.Count > 0)
                    dataWorkloadList.ForEach(t => response.Workload.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                var sheetEconomic = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeEconomic);
                if (sheetEconomic == null)
                    return null;
                var dataEconomicList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetEconomic.ID && t.UnitType == 1 && t.IsTotal != 1 && t.AccountingUnit == doctor.AccountingUnit);
                if (dataEconomicList != null && dataEconomicList.Count > 0)
                    dataEconomicList.ForEach(t => response.Economic.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                return response;
            }
            else if (type == 2)
            {
                var nurse = _perforResAccountnurseRepository.GetEntity(t => t.AllotID == allotId && t.ID == accountId);
                DeptDetailResponse response = new DeptDetailResponse()
                {
                    Pandect = Mapper.Map<PerDataAccount>(nurse),
                    Economic = new List<DeptDetail>(),
                    Workload = new List<DeptDetail>()
                };

                var sheetWorkload = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeNurseWorkload);
                if (sheetWorkload == null)
                    return null;
                var dataWorkloadList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetWorkload.ID && t.IsTotal != 1 && t.AccountingUnit == nurse.AccountingUnit);
                if (dataWorkloadList != null && dataWorkloadList.Count > 0)
                    dataWorkloadList.ForEach(t => response.Workload.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                var sheetEconomic = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeEconomic);
                if (sheetEconomic == null)
                    return null;
                var dataEconomicList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetEconomic.ID && t.UnitType == 2 && t.IsTotal != 1 && t.AccountingUnit == nurse.AccountingUnit);
                if (dataEconomicList != null && dataEconomicList.Count > 0)
                    dataEconomicList.ForEach(t => response.Economic.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));
                return response;
            }

            return null;
        }

        /// <summary>
        /// 返回绩效发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<ComputeResponse> AllCompute(int allotId)
        {
            var list = new List<ComputeResponse>();
            var allot = _perforRescomputeRepository.GetEntities(t => t.AllotID == allotId);
            list = Mapper.Map<List<ComputeResponse>>(allot);
            list?.ForEach(t => t.Source = "一次绩效");
            var employee = _perforAgemployeeRepository.GetEntities(t => t.AllotID == allotId);
            if (employee != null && employee.Count > 0)
            {
                var again = _perforPeragainallotRepository.GetEntities(t => employee.Select(e => e.AgainAllotID).Contains(t.ID));
                if (again != null)
                {
                    var data = _perforUserRepository.GetEntities(t => again.Select(a => a.CreateUser).Contains(t.ID) && t.States == 1);
                    var list1 = from e in employee
                                join a in again on e.AgainAllotID equals a.ID
                                join user in data on a.CreateUser equals user.ID
                                select new ComputeResponse
                                {
                                    Source = "二次绩效",
                                    AccountingUnit = a.Department,
                                    EmployeeName = user.RealName,
                                    JobTitle = e.JobTitle,
                                    RealGiveFee = e.RealGiveFee
                                };
                    list = list.Union(list1.OrderBy(t => t.AccountingUnit)).ToList();
                }
            }
            return list;
        }
    }
}
