﻿using AutoMapper;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class ConfigService : IAutoInjection
    {
        private PerforCofdirectorRepository _directorRepository;
        private PerforCofdrugpropRepository _drugpropRepository;
        private PerforCofincomeRepository _incomeRepository;
        private PerforCofworkyearRepository _workyearRepository;
        private PerforCofagainRepository _againRepository;
        private PerforPerallotRepository perforPerAllotRepository;
        private PerforPeragainallotRepository perforPeragainallotRepository;
        private PerforLogdbugRepository logdbug;
        public ConfigService(PerforCofdirectorRepository cofdirectorRepository,
            PerforCofdrugpropRepository cofdrugpropRepository,
            PerforCofincomeRepository cofincomeRepository,
            PerforCofworkyearRepository cofworkyearRepository,
            PerforCofagainRepository againRepository,
            PerforPerallotRepository perforPerAllotRepository,
            PerforPeragainallotRepository perforPeragainallotRepository,
            PerforLogdbugRepository logdbug)
        {
            this._directorRepository = cofdirectorRepository;
            this._drugpropRepository = cofdrugpropRepository;
            this._incomeRepository = cofincomeRepository;
            this._workyearRepository = cofworkyearRepository;
            this._againRepository = againRepository;
            this.perforPerAllotRepository = perforPerAllotRepository;
            this.perforPeragainallotRepository = perforPeragainallotRepository;
            this.logdbug = logdbug;
        }

        #region cof_director
        /// <summary>
        /// 获取cof_director列表
        /// </summary>
        /// <returns></returns>
        public List<DirectorResponse> GetDireList(int allotId)
        {
            var list = _directorRepository.GetEntities(t => t.AllotID == allotId);
            return Mapper.Map<List<DirectorResponse>>(list);
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public DirectorResponse DireInsert(DirectorRequest request)
        {
            var director = Mapper.Map<cof_director>(request);
            if (!_directorRepository.Add(director))
                throw new PerformanceException("保存失败");
            return Mapper.Map<DirectorResponse>(director);
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public DirectorResponse DireUpdate(DirectorRequest request)
        {
            var director = _directorRepository.GetEntity(t => t.ID == request.ID);
            if (null == director)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            director.TypeName = request.TypeName;
            director.JobTitle = request.JobTitle;
            director.Value = request.Value;

            if (!_directorRepository.Update(director))
                throw new PerformanceException("保存失败");
            return Mapper.Map<DirectorResponse>(director);
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public bool DireDelete(DirectorRequest request)
        {
            var director = _directorRepository.GetEntity(t => t.ID == request.ID);
            if (null == director)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            return _directorRepository.Remove(director);
        }
        #endregion

        #region cof_drugprop
        /// <summary>
        /// 获取cof_drugprop列表
        /// </summary>
        /// <returns></returns>
        public List<DrugpropResponse> GetDrugList(int allotId)
        {
            var list = _drugpropRepository.GetEntities(t => t.AllotID == allotId);
            return Mapper.Map<List<DrugpropResponse>>(list);
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public DrugpropResponse DrugInsert(DrugpropRequest request)
        {
            var drugprop = Mapper.Map<cof_drugprop>(request);
            if (!_drugpropRepository.Add(drugprop))
                throw new PerformanceException("保存失败");
            return Mapper.Map<DrugpropResponse>(drugprop);
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public DrugpropResponse DrugUpdate(DrugpropRequest request)
        {
            var drugprop = _drugpropRepository.GetEntity(t => t.ID == request.ID);
            if (null == drugprop)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            drugprop.MaxRange = request.MaxRange;
            drugprop.MinRange = request.MinRange;
            drugprop.Value = request.Value;

            if (!_drugpropRepository.Update(drugprop))
                throw new PerformanceException("保存失败");
            return Mapper.Map<DrugpropResponse>(drugprop);
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public bool DrugDelete(DrugpropRequest request)
        {
            var drugprop = _drugpropRepository.GetEntity(t => t.ID == request.ID);
            if (null == drugprop)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            return _drugpropRepository.Remove(drugprop);
        }
        #endregion

        #region cof_income
        /// <summary>
        /// 获取cof_income列表
        /// </summary>
        /// <returns></returns>
        public List<IncomeResponse> GetIncomeList(int allotId)
        {
            var list = _incomeRepository.GetEntities(T => T.AllotID == allotId);
            return Mapper.Map<List<IncomeResponse>>(list);
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IncomeResponse IncomeInsert(IncomeRequest request)
        {
            var income = Mapper.Map<cof_income>(request);
            if (!_incomeRepository.Add(income))
                throw new PerformanceException("保存失败");
            return Mapper.Map<IncomeResponse>(income);
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IncomeResponse IncomeUpdate(IncomeRequest request)
        {
            var income = _incomeRepository.GetEntity(t => t.ID == request.ID);
            if (null == income)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            income.SheetNameKeyword = request.SheetNameKeyword;
            income.UnitName = request.UnitName;
            income.Value = request.Value;

            if (!_incomeRepository.Update(income))
                throw new PerformanceException("保存失败");
            return Mapper.Map<IncomeResponse>(income);
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public bool IncomeDelete(IncomeRequest request)
        {
            var income = _incomeRepository.GetEntity(t => t.ID == request.ID);
            if (null == income)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            return _incomeRepository.Remove(income);
        }
        #endregion

        #region cof_workyear
        /// <summary>
        /// 获取cof_drugprop列表
        /// </summary>
        /// <returns></returns>
        public List<WorkyearResponse> GetWorkList(int allotId)
        {
            var list = _workyearRepository.GetEntities(t => t.AllotID == allotId);
            return Mapper.Map<List<WorkyearResponse>>(list);
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public WorkyearResponse WorkInsert(WorkyearRequest request)
        {
            var workyear = Mapper.Map<cof_workyear>(request);
            if (!_workyearRepository.Add(workyear))
                throw new PerformanceException("保存失败");
            return Mapper.Map<WorkyearResponse>(workyear);
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public WorkyearResponse WorkUpdate(WorkyearRequest request)
        {
            var workyear = _workyearRepository.GetEntity(t => t.ID == request.ID);
            if (null == workyear)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            workyear.MaxRange = request.MaxRange;
            workyear.MinRange = request.MinRange;
            workyear.Value = request.Value;

            if (!_workyearRepository.Update(workyear))
                throw new PerformanceException("保存失败");
            return Mapper.Map<WorkyearResponse>(workyear);
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public bool WorkDelete(WorkyearRequest request)
        {
            var workyear = _workyearRepository.GetEntity(t => t.ID == request.ID);
            if (null == workyear)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            return _workyearRepository.Remove(workyear);
        }
        #endregion

        /// <summary>
        /// 清楚无效数据
        /// </summary>
        /// <param name="allotId"></param>
        public void Clear(int allotId)
        {
            var count = _directorRepository.DeleteData(allotId);
            logdbug.Add(allotId, "清理无效数据", $"受影响行数：{count}");
        }

        #region Copy
        /// <summary>
        /// 复制报表基础配置
        /// </summary>
        /// <param name="iD"></param>
        public void Copy(per_allot allot)
        {
            var list = perforPerAllotRepository.GetEntities(t => t.HospitalId == allot.HospitalId)
                         .OrderBy(t => t.Year).ThenBy(t => t.Month).ToList();
            int allotId = 0;
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i].ID == allot.ID && (i - 1) >= 0)
                    allotId = list[i - 1].ID;
            }
            var orgDirector = _directorRepository.GetEntities(t => t.AllotID == allot.ID);
            if (orgDirector == null || orgDirector.Count == 0)
            {
                var director = _directorRepository.GetEntities(t => t.AllotID == allotId) ?? _directorRepository.GetEntities(t => t.AllotID == -1);
                var newDirectors = director.Select(t => new cof_director { AllotID = allot.ID, JobTitle = t.JobTitle, TypeName = t.TypeName, Value = t.Value });
                _directorRepository.AddRange(newDirectors.ToArray());
            }

            var orgDurgprop = _drugpropRepository.GetEntities(t => t.AllotID == allot.ID);
            if (orgDurgprop == null || orgDurgprop.Count == 0)
            {
                var durgprop = _drugpropRepository.GetEntities(t => t.AllotID == allotId) ?? _drugpropRepository.GetEntities(t => t.AllotID == -1);
                var newDurgprops = durgprop.Select(t => new cof_drugprop { AllotID = allot.ID, MaxRange = t.MaxRange, MinRange = t.MinRange, Value = t.Value });
                _drugpropRepository.AddRange(newDurgprops.ToArray());
            }

            var orgIncome = _incomeRepository.GetEntities(t => t.AllotID == allot.ID);
            if (orgIncome == null || orgIncome.Count == 0)
            {
                var income = _incomeRepository.GetEntities(t => t.AllotID == allotId) ?? _incomeRepository.GetEntities(t => t.AllotID == -1);
                var newIncomes = income.Select(t => new cof_income { AllotID = allot.ID, SheetNameKeyword = t.SheetNameKeyword, UnitName = t.UnitName, Value = t.Value });
                _incomeRepository.AddRange(newIncomes.ToArray());
            }

            var orgWorkyear = _workyearRepository.GetEntities(t => t.AllotID == allot.ID);
            if (orgWorkyear == null || orgWorkyear.Count == 0)
            {
                var workyear = _workyearRepository.GetEntities(t => t.AllotID == allotId) ?? _workyearRepository.GetEntities(t => t.AllotID == -1);
                var newWorkyears = workyear.Select(t => new cof_workyear { AllotID = allot.ID, MaxRange = t.MaxRange, MinRange = t.MinRange, Value = t.Value });
                _workyearRepository.AddRange(newWorkyears.ToArray());
            }
        }
        #endregion

        #region cof_again
        /// <summary>
        /// 获取cof_drugprop列表
        /// </summary>
        /// <returns></returns>
        public List<cof_again> GetAgainList(int againId)
        {
            var list = _againRepository.GetEntities(t => t.AgainAllotID == againId);
            return list;
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public cof_again AgainInsert(CofAgainRequest request)
        {
            var workyear = Mapper.Map<cof_again>(request);
            if (!_againRepository.Add(workyear))
                throw new PerformanceException("保存失败");
            return workyear;
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public cof_again AgainUpdate(CofAgainRequest request)
        {
            var again = _againRepository.GetEntity(t => t.ID == request.ID);
            if (null == again)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            again.Type = request.Type;
            again.TypeName = request.TypeName;
            again.Value = request.Value;

            if (!_againRepository.Update(again))
                throw new PerformanceException("保存失败");
            return again;
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public bool AgainDelete(CofAgainRequest request)
        {
            var again = _againRepository.GetEntity(t => t.ID == request.ID);
            if (null == again)
                throw new PerformanceException($"ID不存在 ：{request.ID}");

            return _againRepository.Remove(again);
        }
        #endregion

        /// <summary>
        /// 清楚二次绩效中无效数据
        /// </summary>
        /// <param name="againId"></param>
        public void ClearAgain(int againId)
        {
            var count = _directorRepository.DelAgain(againId);
            logdbug.Add(againId, "清楚二次绩效中无效数据", $"受影响行数：{count}");
        }

        #region CopyAgain
        /// <summary>
        /// 复制报表基础配置
        /// </summary>
        /// <param name="iD"></param>
        public void CopyAgain(int againid)
        {
            var again = perforPeragainallotRepository.GetEntity(t => t.ID == againid);
            if (again == null)
                throw new PerformanceException("二次绩效不存在");
            var allot = perforPerAllotRepository.GetEntity(t => t.ID == again.AllotID);
            if (allot == null)
                throw new PerformanceException("绩效不存在");

            var list = perforPerAllotRepository.GetEntities(t => t.HospitalId == allot.HospitalId)
                         .OrderBy(t => t.Year).ThenBy(t => t.Month).ToList();
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i].ID == allot.ID && (i - 1) >= 0)
                    allot = list[i - 1];
            }
            //根据上月绩效获取二次绩效信息
            var beforeAgain = perforPeragainallotRepository.GetEntity(t => t.AllotID == allot.ID && t.CreateUser == again.CreateUser);
            var record = _againRepository.GetEntities(t => t.AgainAllotID == -1);

            if (again.AllotID != allot.ID && beforeAgain != null)
                record = _againRepository.GetEntities(t => t.AgainAllotID == beforeAgain.ID);
            //int days = DateTime.DaysInMonth(allot.Year, allot.Month);
            var againList = record.Select(t => new cof_again
            {
                AllotID = allot.ID,
                AgainAllotID = againid,
                Type = t.Type,
                TypeName = t.TypeName,
                Value = t.Value
            });
            _againRepository.AddRange(againList.ToArray());
        }
        #endregion
    }
}
