﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 临床科室单元核算表
    /// </summary>
    public class PerSheetDataReadDeptAccountingt : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 2,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 3,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                var accountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.ToString();

                PerDataAccountBaisc unifyUnit = new PerDataAccountBaisc();
                unifyUnit.RowNumber = r;
                unifyUnit.AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.ToString();
                unifyUnit.Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell)?.ToString();
                unifyUnit.DoctorNumber = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元医生数量" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorBasicFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "基础系数" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorSlopeFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "倾斜系数" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorOtherPerfor1 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效1" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorOtherPerfor2 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效2" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorExtra = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorScoringAverage = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.DoctorAdjustFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数" && p.Parent.CellValue == "医生组").PointCell)?.ToString());
                unifyUnit.NurseNumber = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元护士数量" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseBasicFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "基础系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseSlopeFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "倾斜系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseOtherPerfor1 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效1" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseOtherPerfor2 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效2" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseExtra = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseScoringAverage = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                unifyUnit.NurseAdjustFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());

                dataList.Add(unifyUnit);
            }

            return dataList;
        }
    }
}
