﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class PerSheetDataReadSpecialUnit : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                var accountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell)?.ToString();
                if (string.IsNullOrEmpty(accountingUnit))
                    continue;
                PerDataSpecialUnit employee = new PerDataSpecialUnit
                {
                    RowNumber = r,
                    AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell)?.ToString(),
                    Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell)?.ToString(),
                    Number = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人数").PointCell)?.ToString()),
                    QuantitativeIndicators = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "量化指标").PointCell)?.ToString(),
                    Quantity = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "数量").PointCell)?.ToString()),
                    QuantitativeIndicatorsValue = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "量化指标绩效分值").PointCell)?.ToString()),
                    ScoringAverage = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.ToString()),
                    OtherPerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell)?.ToString()),
                    Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.ToString()),
                    Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.ToString()),
                };
                dataList.Add(employee);
            }

            return dataList;
        }
    }
}
